/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.compat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.es.ElasticSearchRequest;
import org.janusgraph.diskstorage.indexing.IndexFeatures;

public abstract class AbstractESCompat {
    static final Map<String, Object> MATCH_ALL = ImmutableMap.of((Object)"match_all", (Object)Collections.EMPTY_MAP);

    static IndexFeatures.Builder coreFeatures() {
        return new IndexFeatures.Builder().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.TEXTSTRING, Mapping.STRING}).setWildcardField("_all").supportsCardinality(Cardinality.SINGLE).supportsCardinality(Cardinality.LIST).supportsCardinality(Cardinality.SET).supportsNanoseconds().supportsCustomAnalyzer().supportsGeoExists().supportNotQueryNormalForm();
    }

    public abstract IndexFeatures getIndexFeatures();

    public Map<String, Object> createKeywordMapping() {
        return ImmutableMap.of((Object)"type", (Object)"keyword");
    }

    public Map<String, Object> createTextMapping(String textAnalyzer) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"type", (Object)"text");
        return (textAnalyzer != null ? builder.put((Object)"analyzer", (Object)textAnalyzer) : builder).build();
    }

    public String scriptLang() {
        return "painless";
    }

    public ImmutableMap.Builder<String, Object> prepareScript(String source) {
        ImmutableMap script = ImmutableMap.of((Object)"source", (Object)source, (Object)"lang", (Object)this.scriptLang());
        return ImmutableMap.builder().put((Object)"script", (Object)script);
    }

    public ImmutableMap.Builder<String, Object> prepareStoredScript(String scriptId, List<Map<String, Object>> fields) {
        ImmutableMap script = ImmutableMap.of((Object)"id", (Object)scriptId, (Object)"params", (Object)ImmutableMap.of((Object)"fields", fields));
        return ImmutableMap.builder().put((Object)"script", (Object)script);
    }

    public ImmutableMap.Builder<String, Object> prepareInlineScript(String source, List<Map<String, Object>> fields) {
        ImmutableMap script = ImmutableMap.of((Object)"source", (Object)source, (Object)"params", (Object)ImmutableMap.of((Object)"fields", fields), (Object)"lang", (Object)this.scriptLang());
        return ImmutableMap.builder().put((Object)"script", (Object)script);
    }

    public Map<String, Object> prepareQuery(Map<String, Object> query) {
        return query;
    }

    public Map<String, Object> term(String key, Object value) {
        return ImmutableMap.of((Object)"term", (Object)ImmutableMap.of((Object)key, (Object)value));
    }

    public Map<String, Object> contains(String key, List<String> terms) {
        return this.boolMust(terms.stream().map(term -> this.term(key, term)).collect(Collectors.toList()));
    }

    public Map<String, Object> boolMust(List<Map<String, Object>> queries) {
        return queries.size() > 1 ? ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", queries)) : queries.get(0);
    }

    public Map<String, Object> boolMustNot(Map<String, Object> query) {
        return ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must_not", query));
    }

    public Map<String, Object> boolShould(List<Map<String, Object>> queries) {
        return ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"should", queries));
    }

    public Map<String, Object> boolFilter(Map<String, Object> query) {
        return ImmutableMap.of((Object)"bool", (Object)ImmutableMap.of((Object)"must", MATCH_ALL, (Object)"filter", query));
    }

    public Map<String, Object> lt(String key, Object value) {
        return ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"lt", (Object)value)));
    }

    public Map<String, Object> lte(String key, Object value) {
        return ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"lte", (Object)value)));
    }

    public Map<String, Object> gt(String key, Object value) {
        return ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"gt", (Object)value)));
    }

    public Map<String, Object> gte(String key, Object value) {
        return ImmutableMap.of((Object)"range", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"gte", (Object)value)));
    }

    public Map<String, Object> prefix(String key, Object value) {
        return ImmutableMap.of((Object)"prefix", (Object)ImmutableMap.of((Object)key, (Object)value));
    }

    public Map<String, Object> regexp(String key, Object value) {
        return ImmutableMap.of((Object)"regexp", (Object)ImmutableMap.of((Object)key, (Object)value));
    }

    public Map<String, Object> exists(String key) {
        return ImmutableMap.of((Object)"exists", (Object)ImmutableMap.of((Object)"field", (Object)key));
    }

    public Map<String, Object> match(String key, Object value) {
        return this.match(key, value, null);
    }

    public Map<String, Object> matchPhrase(String key, Object value) {
        return ImmutableMap.of((Object)"match_phrase", (Object)ImmutableMap.of((Object)key, (Object)value));
    }

    public Map<String, Object> fuzzyMatch(String key, Object value) {
        return this.match(key, value, "AUTO");
    }

    public Map<String, Object> match(String key, Object value, String fuzziness) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"query", value);
        builder.put((Object)"operator", (Object)"and");
        if (fuzziness != null) {
            builder.put((Object)"fuzziness", (Object)fuzziness);
        }
        return ImmutableMap.of((Object)"match", (Object)ImmutableMap.of((Object)key, (Object)builder.build()));
    }

    public Map<String, Object> queryString(Object query) {
        return ImmutableMap.of((Object)"query_string", (Object)ImmutableMap.of((Object)"query", (Object)query));
    }

    public Map<String, Object> geoDistance(String key, double lat, double lon, double radius) {
        return this.filter((Map<String, Object>)ImmutableMap.of((Object)"geo_distance", (Object)ImmutableMap.of((Object)"distance", (Object)(radius + "km"), (Object)key, (Object)ImmutableList.of((Object)lon, (Object)lat))));
    }

    public Map<String, Object> geoBoundingBox(String key, double minLat, double minLon, double maxLat, double maxLon) {
        return this.filter((Map<String, Object>)ImmutableMap.of((Object)"geo_bounding_box", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"top_left", (Object)ImmutableList.of((Object)minLon, (Object)maxLat), (Object)"bottom_right", (Object)ImmutableList.of((Object)maxLon, (Object)minLat)))));
    }

    public Map<String, Object> geoPolygon(String key, List<List<Double>> points) {
        return this.filter((Map<String, Object>)ImmutableMap.of((Object)"geo_polygon", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"points", points))));
    }

    public Map<String, Object> geoShape(String key, Map<String, Object> geoShape, Geo predicate) {
        String relation = predicate == Geo.INTERSECT ? "intersects" : predicate.name().toLowerCase();
        return this.filter((Map<String, Object>)ImmutableMap.of((Object)"geo_shape", (Object)ImmutableMap.of((Object)key, (Object)ImmutableMap.of((Object)"shape", geoShape, (Object)"relation", (Object)relation))));
    }

    public Map<String, Object> filter(Map<String, Object> query) {
        return this.boolFilter(query);
    }

    public Map<String, Object> createRequestBody(ElasticSearchRequest request, Parameter[] parameters) {
        Map<String, Object> requestBody = this.createRequestBody(request.getQuery(), parameters);
        if (request.getSize() != null) {
            requestBody.put("size", request.getSize());
        }
        if (request.getFrom() != null) {
            requestBody.put("from", request.getFrom());
        }
        if (!request.getSorts().isEmpty()) {
            requestBody.put("sort", request.getSorts());
        }
        if (request.isDisableSourceRetrieval()) {
            requestBody.put("_source", false);
        }
        return requestBody;
    }

    public Map<String, Object> createRequestBody(Map<String, Object> query, Parameter[] parameters) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        if (query != null) {
            requestBody.put("query", query);
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                requestBody.put(parameter.key(), parameter.value());
            }
        }
        return requestBody;
    }
}

