/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.tinkerpop.io.binary.GraphBinaryType;
import org.janusgraph.graphdb.tinkerpop.io.binary.JanusGraphTypeSerializer;

public class RelationIdentifierGraphBinarySerializer
extends JanusGraphTypeSerializer<RelationIdentifier> {
    public static final byte LONG_MARKER = 0;
    public static final byte STRING_MARKER = 1;

    public RelationIdentifierGraphBinarySerializer() {
        super(GraphBinaryType.RelationIdentifier);
    }

    private void writeString(Buffer buffer, String value) {
        byte[] arr = new byte[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            assert (c <= '\u007f');
            byte b = (byte)c;
            if (i + 1 == value.length()) {
                b = (byte)(b | 0x80);
            }
            arr[i] = b;
        }
        buffer.writeBytes(arr);
    }

    private String readString(Buffer buffer) {
        int c;
        StringBuilder sb = new StringBuilder();
        do {
            c = 0xFF & buffer.readByte();
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        return sb.toString();
    }

    @Override
    public RelationIdentifier readNonNullableValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        Object inVertexId;
        byte outVertexIdMarker = buffer.readByte();
        Object outVertexId = outVertexIdMarker == 1 ? this.readString(buffer) : Long.valueOf(buffer.readLong());
        long typeId = buffer.readLong();
        long relationId = buffer.readLong();
        byte inVertexIdMarker = buffer.readByte();
        if (inVertexIdMarker == 1) {
            inVertexId = this.readString(buffer);
        } else {
            inVertexId = buffer.readLong();
            if (inVertexId.equals(0L)) {
                inVertexId = null;
            }
        }
        return new RelationIdentifier(outVertexId, typeId, relationId, inVertexId);
    }

    @Override
    protected void writeNonNullableValue(RelationIdentifier value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        Object outVertexId = value.getOutVertexId();
        if (outVertexId instanceof Number) {
            buffer.writeByte(0);
            buffer.writeLong(((Number)outVertexId).longValue());
        } else {
            assert (outVertexId instanceof String);
            buffer.writeByte(1);
            this.writeString(buffer, (String)outVertexId);
        }
        buffer.writeLong(value.getTypeId());
        buffer.writeLong(value.getRelationId());
        Object inVertexId = value.getInVertexId();
        if (inVertexId == null) {
            buffer.writeByte(0);
            buffer.writeLong(0L);
        } else if (inVertexId instanceof Number) {
            buffer.writeByte(0);
            buffer.writeLong(((Number)inVertexId).longValue());
        } else {
            assert (inVertexId instanceof String);
            buffer.writeByte(1);
            this.writeString(buffer, (String)inVertexId);
        }
    }
}

