/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.strategy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.ReplicasAwareGroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.TokenRangeAwareGroupedExecutionStrategy;
import org.janusgraph.diskstorage.util.backpressure.builder.QueryBackPressureBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupedExecutionStrategyBuilder {
    private static final Logger log = LoggerFactory.getLogger(QueryBackPressureBuilder.class);
    public static final String TOKEN_RANGE_AWARE = "tokenRangeAware";
    public static final String REPLICAS_AWARE = "replicasAware";

    private GroupedExecutionStrategyBuilder() {
    }

    public static GroupedExecutionStrategy build(Configuration configuration, CQLStoreManager storeManager, String className) {
        switch (className) {
            case "tokenRangeAware": {
                return new TokenRangeAwareGroupedExecutionStrategy(configuration, storeManager);
            }
            case "replicasAware": {
                return new ReplicasAwareGroupedExecutionStrategy(configuration, storeManager);
            }
        }
        return GroupedExecutionStrategyBuilder.buildFromClassName(className, configuration, storeManager);
    }

    private static GroupedExecutionStrategy buildFromClassName(String className, Configuration configuration, CQLStoreManager storeManager) {
        GroupedExecutionStrategy result;
        Class<?> implementationClass;
        try {
            implementationClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No class found with class name: " + className);
        }
        if (!GroupedExecutionStrategy.class.isAssignableFrom(implementationClass)) {
            throw new IllegalArgumentException(className + "isn't a subclass of " + GroupedExecutionStrategy.class.getName());
        }
        Constructor<?> constructorWithConfigurationAndSessionParams = null;
        for (Constructor<?> constructor : implementationClass.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 2 || !Configuration.class.isAssignableFrom(constructor.getParameterTypes()[0]) || !CQLStoreManager.class.isAssignableFrom(constructor.getParameterTypes()[1])) continue;
            constructorWithConfigurationAndSessionParams = constructor;
            break;
        }
        try {
            if (constructorWithConfigurationAndSessionParams == null) {
                throw new IllegalArgumentException(className + " has no a public constructor which accepts " + Configuration.class.getName() + " and " + CQLStoreManager.class.getName() + " parameters.");
            }
            result = (GroupedExecutionStrategy)constructorWithConfigurationAndSessionParams.newInstance(new Object[]{configuration, storeManager});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Couldn't create a new instance of " + className + ". Please, check that the constructor which accepts " + Configuration.class.getName() + " and " + CQLStoreManager.class.getName() + " is public. If the necessary public constructor exists, please, check that invocation of this constructor doesn't throw an exception.", e);
        }
        log.info("Initiated custom GroupedExecutionStrategy {}", (Object)className);
        return result;
    }
}

