/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.CompletableFutureUtil;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class CQLMutateManyUnloggedFunction
extends AbstractCQLMutateManyFunction
implements CQLMutateManyFunction {
    private final CqlSession session;
    private final int batchSize;
    private final QueryBackPressure queryBackPressure;

    public CQLMutateManyUnloggedFunction(int batchSize, CqlSession session, Map<String, CQLKeyColumnValueStore> openStores, TimestampProvider times, boolean assignTimestamp, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction, QueryBackPressure queryBackPressure) {
        super(sleepAfterWriteFunction, assignTimestamp, times, openStores);
        this.session = session;
        this.batchSize = batchSize;
        this.queryBackPressure = queryBackPressure;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        DistributedStoreManager.MaskedTimestamp commitTime = (DistributedStoreManager.MaskedTimestamp)this.createMaskedTimestampFunction.apply(txh);
        ArrayList resultList = new ArrayList();
        mutations.forEach((tableName, tableMutations) -> {
            CQLKeyColumnValueStore columnValueStore = this.getColumnValueStore((String)tableName);
            tableMutations.forEach((key, keyMutations) -> this.toGroupedBatchableStatementsSequenceIterator(commitTime, (KCVMutation)keyMutations, columnValueStore, (StaticBuffer)key).forEach(group -> resultList.add(this.execAsyncUnlogged((Seq<BatchableStatement<BoundStatement>>)group, txh))));
        });
        try {
            CompletableFutureUtil.awaitAll(resultList);
        }
        catch (Throwable e) {
            throw CQLKeyColumnValueStore.EXCEPTION_MAPPER.apply(e);
        }
        this.sleepAfterWriteFunction.accept(commitTime);
    }

    protected CompletableFuture<AsyncResultSet> execAsyncUnlogged(Seq<BatchableStatement<BoundStatement>> group, StoreTransaction txh) {
        this.queryBackPressure.acquireBeforeQuery();
        try {
            return this.session.executeAsync(BatchStatement.newInstance((BatchType)DefaultBatchType.UNLOGGED).addAll(group).setConsistencyLevel(CQLTransaction.getTransaction(txh).getWriteConsistencyLevel())).whenComplete((asyncResultSet, throwable) -> this.queryBackPressure.releaseAfterQuery()).toCompletableFuture();
        }
        catch (RuntimeException e) {
            this.queryBackPressure.releaseAfterQuery();
            throw e;
        }
    }

    protected Iterator<Seq<BatchableStatement<BoundStatement>>> toGroupedBatchableStatementsSequenceIterator(DistributedStoreManager.MaskedTimestamp commitTime, KCVMutation keyMutations, CQLKeyColumnValueStore columnValueStore, StaticBuffer key) {
        Iterator<BatchableStatement<BoundStatement>> deletions = this.deletionsFunction.getBatchableStatementsForColumnOperation(commitTime, keyMutations, columnValueStore, key);
        Iterator<BatchableStatement<BoundStatement>> additions = this.additionsFunction.getBatchableStatementsForColumnOperation(commitTime, keyMutations, columnValueStore, key);
        return Iterator.concat((Iterable[])new Iterable[]{deletions, additions}).grouped(this.batchSize);
    }
}

