/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class ConfigurationUtil {
    private static final char CONFIGURATION_SEPARATOR = '.';
    private static final DefaultListDelimiterHandler COMMA_DELIMITER_HANDLER = new DefaultListDelimiterHandler(',');

    public static List<String> getUniquePrefixes(Configuration config) {
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<String> names = new ArrayList<String>();
        Iterator keyIterator = config.getKeys();
        while (keyIterator.hasNext()) {
            String name;
            String key = (String)keyIterator.next();
            int pos = key.indexOf(46);
            if (pos <= 0 || !nameSet.add(name = key.substring(0, pos))) continue;
            names.add(name);
        }
        return names;
    }

    public static <T> T instantiate(String className) {
        return ConfigurationUtil.instantiate(className, new Object[0], new Class[0]);
    }

    public static <T> T instantiate(String className, Object[] constructorArgs, Class[] classes) {
        Preconditions.checkArgument((constructorArgs != null && classes != null ? 1 : 0) != 0);
        Preconditions.checkArgument((constructorArgs.length == classes.length ? 1 : 0) != 0);
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(classes);
            return (T)constructor.newInstance(constructorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Implementation class does not have required constructor: " + className, e);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + className, e);
        }
    }

    public static boolean hasConstructor(String className, Class[] constructorArgumentClasses) {
        Preconditions.checkArgument((constructorArgumentClasses != null ? 1 : 0) != 0);
        try {
            Class<?> clazz = Class.forName(className);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != constructorArgumentClasses.length) continue;
                for (int i = 0; i < constructorArgumentClasses.length && constructor.getParameterTypes()[i].isAssignableFrom(constructorArgumentClasses[i]); ++i) {
                }
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + className, e);
        }
    }

    public static BaseConfiguration createBaseConfiguration() {
        BaseConfiguration baseConfiguration = new BaseConfiguration();
        baseConfiguration.setListDelimiterHandler((ListDelimiterHandler)COMMA_DELIMITER_HANDLER);
        return baseConfiguration;
    }

    public static MapConfiguration loadMapConfiguration(Map<String, Object> configMap) {
        MapConfiguration mapConfiguration = new MapConfiguration(configMap);
        mapConfiguration.setListDelimiterHandler((ListDelimiterHandler)COMMA_DELIMITER_HANDLER);
        return mapConfiguration;
    }

    public static PropertiesConfiguration loadPropertiesConfig(String filename) throws ConfigurationException {
        return ConfigurationUtil.loadPropertiesConfig(filename, true);
    }

    public static PropertiesConfiguration loadPropertiesConfig(String filename, boolean setCommaDelimiterHandler) throws ConfigurationException {
        return ConfigurationUtil.loadPropertiesConfig((PropertiesBuilderParameters)new Parameters().properties().setFileName(filename), setCommaDelimiterHandler);
    }

    public static PropertiesConfiguration loadPropertiesConfig(File file) throws ConfigurationException {
        return ConfigurationUtil.loadPropertiesConfig((PropertiesBuilderParameters)new Parameters().properties().setFile(file), true);
    }

    private static PropertiesConfiguration loadPropertiesConfig(PropertiesBuilderParameters params, boolean setCommaDelimiterHandler) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesBuilderParameters newParams = params;
        if (setCommaDelimiterHandler) {
            newParams = (PropertiesBuilderParameters)newParams.setListDelimiterHandler((ListDelimiterHandler)COMMA_DELIMITER_HANDLER);
        }
        return (PropertiesConfiguration)builder.configure(new BuilderParameters[]{newParams}).getConfiguration();
    }
}

