/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.janusgraph.util.IDUtils;

public class AbstractIdListUtil {
    public static boolean isSorted(List<Object> l, boolean unique) {
        for (int i = 1; i < l.size(); ++i) {
            if (IDUtils.compare((Object)l.get(i), (Object)l.get(i - 1)) >= 0 && (!unique || !Objects.equals(l.get(i), l.get(i - 1)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(List<Object> l) {
        return AbstractIdListUtil.isSorted(l, false);
    }

    public static List<Object> mergeSort(List<Object> a, List<Object> b) {
        int positionA = 0;
        int positionB = 0;
        ArrayList<Object> result = new ArrayList<Object>(a.size() + b.size());
        while (positionA < a.size() || positionB < b.size()) {
            Object next = positionA >= a.size() ? b.get(positionB++) : (positionB >= b.size() ? a.get(positionA++) : (IDUtils.compare((Object)a.get(positionA), (Object)b.get(positionB)) <= 0 ? a.get(positionA++) : b.get(positionB++)));
            Preconditions.checkArgument((result.isEmpty() || IDUtils.compare(result.get(result.size() - 1), (Object)next) <= 0 ? 1 : 0) != 0, (Object)"The input lists are not sorted");
            result.add(next);
        }
        return result;
    }

    public static List<Object> mergeJoin(List<Object> a, List<Object> b, boolean unique) {
        assert (AbstractIdListUtil.isSorted(a)) : a.toString();
        assert (AbstractIdListUtil.isSorted(b)) : b.toString();
        int counterA = 0;
        int counterB = 0;
        int sizeA = a.size();
        int sizeB = b.size();
        ArrayList<Object> merge = new ArrayList<Object>(Math.min(sizeA, sizeB));
        int resultSize = 0;
        while (counterA < sizeA && counterB < sizeB) {
            if (Objects.equals(a.get(counterA), b.get(counterB))) {
                Object value = a.get(counterA);
                if (!unique) {
                    merge.add(value);
                    ++resultSize;
                } else if (resultSize <= 0 || merge.get(resultSize - 1) != value) {
                    merge.add(value);
                    ++resultSize;
                }
                ++counterA;
                ++counterB;
                continue;
            }
            if (IDUtils.compare((Object)a.get(counterA), (Object)b.get(counterB)) < 0) {
                ++counterA;
                continue;
            }
            ++counterB;
        }
        return merge;
    }
}

