/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.profile;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class TP3ProfileWrapper
implements QueryProfiler {
    private final MutableMetrics metrics;
    private int subMetricCounter = 0;

    public TP3ProfileWrapper(MutableMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public QueryProfiler addNested(String groupName, boolean hasSiblings) {
        if (!hasSiblings && (groupName.equals("AND-query") || groupName.equals("OR-query"))) {
            return this;
        }
        int nextId = this.subMetricCounter++;
        MutableMetrics nested = new MutableMetrics(this.metrics.getId() + "." + groupName + "_" + nextId, groupName);
        this.metrics.addNested(nested);
        return new TP3ProfileWrapper(nested);
    }

    public MutableMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public QueryProfiler setAnnotation(String key, Object value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must be not null");
        Preconditions.checkNotNull((Object)value, (Object)"Value must be not null");
        if (!(value instanceof String) && !(value instanceof Number)) {
            value = value.toString();
        }
        this.metrics.setAnnotation(key, value);
        return this;
    }

    @Override
    public void startTimer() {
        this.metrics.start();
    }

    @Override
    public void stopTimer() {
        this.metrics.stop();
    }

    @Override
    public void setResultSize(long size) {
        this.metrics.incrementCount("elementCount", size);
    }
}

