/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.AbstractJanusGraphMixedIndexAggStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphStepStrategy;

public class JanusGraphMixedIndexCountStrategy
extends AbstractJanusGraphMixedIndexAggStrategy {
    private static final JanusGraphMixedIndexCountStrategy INSTANCE = new JanusGraphMixedIndexCountStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(JanusGraphStepStrategy.class);

    private JanusGraphMixedIndexCountStrategy() {
    }

    @Override
    protected Aggregation getAggregation(GraphStep originalGraphStep) {
        Step currentStep = originalGraphStep.getNextStep();
        while (this.isEligibleToSkip(currentStep)) {
            currentStep = currentStep.getNextStep();
        }
        if (currentStep instanceof CountGlobalStep) {
            return Aggregation.COUNT;
        }
        return null;
    }

    public static JanusGraphMixedIndexCountStrategy instance() {
        return INSTANCE;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }
}

