/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMixedIndexAggStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;

abstract class AbstractJanusGraphMixedIndexAggStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> POSTS = Collections.singleton(JanusGraphLocalQueryOptimizerStrategy.class);

    AbstractJanusGraphMixedIndexAggStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        TraversalHelper.getStepsOfClass(JanusGraphStep.class, traversal).forEach(originalGraphStep -> this.buildMixedIndexAggStep((JanusGraphStep)originalGraphStep, traversal));
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        return POSTS;
    }

    private void buildMixedIndexAggStep(JanusGraphStep originalGraphStep, Traversal.Admin<?, ?> traversal) {
        if (!originalGraphStep.isStartStep()) {
            return;
        }
        Aggregation agg = this.getAggregation(originalGraphStep);
        if (agg == null) {
            return;
        }
        JanusGraphMixedIndexAggStep directQueryAggStep = new JanusGraphMixedIndexAggStep(originalGraphStep, traversal, agg);
        if (directQueryAggStep.getMixedIndexAggQuery() != null) {
            this.applyMixedIndexAggStep(originalGraphStep, directQueryAggStep, traversal, agg.getFieldName() != null);
        }
    }

    protected boolean isEligibleToSkip(Step currentStep) {
        return currentStep instanceof IdentityStep || currentStep instanceof NoOpBarrierStep;
    }

    abstract Aggregation getAggregation(GraphStep var1);

    private void applyMixedIndexAggStep(GraphStep originalGraphStep, JanusGraphMixedIndexAggStep mixedIndexAggStep, Traversal.Admin<?, ?> traversal, boolean hasField) {
        Step currentStep = originalGraphStep.getNextStep();
        while (this.isEligibleToSkip(currentStep)) {
            currentStep = currentStep.getNextStep();
        }
        Step nextStep = currentStep.getNextStep();
        traversal.removeStep(currentStep);
        if (hasField) {
            traversal.removeStep(nextStep);
        }
        TraversalHelper.replaceStep((Step)originalGraphStep, (Step)mixedIndexAggStep, traversal);
    }
}

