/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.PropertiesStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.optimize.step.service.PropertiesFetchingService;
import org.janusgraph.graphdb.tinkerpop.optimize.step.util.PropertiesFetchingUtil;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public class DirectPropertiesFetchingService
implements PropertiesFetchingService {
    private final PropertiesStepBatchFetcher propertiesStepBatchFetcher;
    private final String[] propertyKeys;
    private final Set<String> propertyKeysSet;
    private final boolean prefetchAllPropertiesRequired;
    private QueryProfiler queryProfiler;

    public DirectPropertiesFetchingService(String[] propertyKeys, int batchSize, boolean prefetchAllPropertiesRequired, QueryProfiler queryProfiler) {
        this.propertyKeys = propertyKeys;
        this.propertyKeysSet = new HashSet<String>(Arrays.asList(propertyKeys));
        this.prefetchAllPropertiesRequired = prefetchAllPropertiesRequired;
        this.queryProfiler = queryProfiler;
        this.propertiesStepBatchFetcher = new PropertiesStepBatchFetcher(this::makePropertiesQuery, batchSize);
    }

    @Override
    public Iterator<? extends Property> fetchProperties(Traverser.Admin<Element> traverser, Traversal.Admin<?, ?> traversal) {
        return this.fetchProperties(traversal, (Vertex)traverser.get(), JanusGraphTraverserUtil.getLoops(traverser));
    }

    public Iterator<? extends Property> fetchProperties(Traversal.Admin<?, ?> traversal, Vertex vertex, int loops) {
        return PropertiesFetchingUtil.filterPropertiesIfNeeded(((Iterable)this.propertiesStepBatchFetcher.fetchData(traversal, vertex, loops)).iterator(), this.prefetchAllPropertiesRequired, this.propertyKeysSet);
    }

    public <Q extends BaseVertexQuery> Q makePropertiesQuery(Q query) {
        return PropertiesFetchingUtil.makeBasePropertiesQuery(query, this.prefetchAllPropertiesRequired, this.propertyKeysSet, this.propertyKeys, this.queryProfiler);
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        this.propertiesStepBatchFetcher.registerFirstNewLoopFutureVertexForPrefetching(futureVertex);
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        this.propertiesStepBatchFetcher.registerCurrentLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        this.propertiesStepBatchFetcher.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
    }

    @Override
    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }

    public void setQueryProfiler(QueryProfiler queryProfiler) {
        this.queryProfiler = queryProfiler;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.propertiesStepBatchFetcher.setBatchSize(batchSize);
    }
}

