/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BatchProcessingQueue<T> {
    private final Set<T> allBatchedElements = new HashSet<T>();
    private final ArrayDeque<List<T>> batches = new ArrayDeque(2);
    private List<T> lastBatch = new ArrayList<T>();
    private int batchSize;

    public BatchProcessingQueue(int batchSize) {
        this.batchSize = Math.max(batchSize, 1);
    }

    public void addToBatchToEnd(T element) {
        if (!this.allBatchedElements.add(element)) {
            return;
        }
        if (this.lastBatch.size() >= this.batchSize) {
            this.batches.add(this.lastBatch);
            this.lastBatch = new ArrayList<T>();
        }
        this.lastBatch.add(element);
    }

    public Collection<T> removeFirst() {
        List<Object> batch;
        if (this.batches.isEmpty()) {
            batch = this.lastBatch;
            this.lastBatch = new ArrayList<T>();
        } else {
            batch = this.batches.removeFirst();
        }
        batch.forEach(this.allBatchedElements::remove);
        return batch;
    }

    public Collection<T> removeLast() {
        List<Object> batch;
        if (!this.lastBatch.isEmpty() || this.batches.isEmpty()) {
            batch = this.lastBatch;
            this.lastBatch = new ArrayList<T>();
        } else {
            batch = this.batches.removeLast();
        }
        batch.forEach(this.allBatchedElements::remove);
        return batch;
    }

    public boolean hasElementInAnyBatch(T element) {
        return this.allBatchedElements.contains(element);
    }

    public void softRemoveFromAllElementsRegistration(T element) {
        this.allBatchedElements.remove(element);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

