/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.OptionalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CallStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CoalesceStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupCountStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TraversalSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.olap.computer.FulgoraElementTraversal;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.MultiQueryPositions;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMultiQueryStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphVertexStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphTraversalUtil {
    private static final List<Class<? extends TraversalParent>> MULTIQUERY_COMPATIBLE_PARENTS = Arrays.asList(ConnectiveStep.class, BranchStep.class, CallStep.class, CoalesceStep.class, GroupStep.class, GroupSideEffectStep.class, LocalStep.class, NotStep.class, OptionalStep.class, OrderGlobalStep.class, OrderLocalStep.class, ProjectStep.class, PropertyMapStep.class, TraversalFilterStep.class, TraversalMapStep.class, TraversalSideEffectStep.class, WherePredicateStep.class, WhereTraversalStep.class, AggregateLocalStep.class, AggregateGlobalStep.class, GroupCountStep.class, TraversalFlatMapStep.class, TraversalMapStep.class);

    public static StandardJanusGraph getJanusGraph(Traversal.Admin<?, ?> traversal) {
        Optional optionalGraph = traversal.getGraph();
        if (!optionalGraph.isPresent()) {
            return null;
        }
        Graph graph = (Graph)optionalGraph.get();
        if (graph instanceof StandardJanusGraph) {
            return (StandardJanusGraph)graph;
        }
        if (graph instanceof StandardJanusGraphTx) {
            return ((StandardJanusGraphTx)graph).getGraph();
        }
        return null;
    }

    public static Optional<StandardJanusGraphTx> getJanusGraphTx(Traversal.Admin<?, ?> traversal) {
        Optional optionalGraph = traversal.getGraph();
        if (!optionalGraph.isPresent()) {
            return Optional.empty();
        }
        Graph graph = (Graph)optionalGraph.get();
        if (graph instanceof StandardJanusGraphTx) {
            return Optional.of((StandardJanusGraphTx)graph);
        }
        return Optional.empty();
    }

    public static JanusGraphVertex getJanusGraphVertex(Element v) {
        while (v instanceof WrappedVertex) {
            v = (Element)((WrappedVertex)v).getBaseVertex();
        }
        if (v instanceof JanusGraphVertex) {
            return (JanusGraphVertex)v;
        }
        throw new IllegalArgumentException("Expected traverser of JanusGraph vertex but found: " + v);
    }

    public static JanusGraphVertex getJanusGraphVertex(Traverser<? extends Element> traverser) {
        return JanusGraphTraversalUtil.getJanusGraphVertex((Element)traverser.get());
    }

    public static boolean isEdgeReturnStep(JanusGraphVertexStep vertexStep) {
        return Edge.class.isAssignableFrom(vertexStep.getReturnClass());
    }

    public static boolean isVertexReturnStep(JanusGraphVertexStep vertexStep) {
        return Vertex.class.isAssignableFrom(vertexStep.getReturnClass());
    }

    public static Step getNextNonIdentityStep(Step start) {
        Step currentStep = start.getNextStep();
        while (currentStep instanceof IdentityStep) {
            currentStep = currentStep.getNextStep();
        }
        return currentStep;
    }

    public static JanusGraphTransaction getTx(Traversal.Admin<?, ?> traversal) {
        JanusGraphTransaction tx;
        Optional optGraph = TraversalHelper.getRootTraversal((Traversal.Admin)traversal.asAdmin()).getGraph();
        if (traversal instanceof FulgoraElementTraversal) {
            tx = (JanusGraphTransaction)optGraph.get();
        } else {
            if (!optGraph.isPresent()) {
                throw new IllegalArgumentException("Traversal is not bound to a graph: " + traversal);
            }
            Graph graph = (Graph)optGraph.get();
            if (graph instanceof JanusGraphTransaction) {
                tx = (JanusGraphTransaction)graph;
            } else if (graph instanceof JanusGraphBlueprintsGraph) {
                tx = ((JanusGraphBlueprintsGraph)graph).getCurrentThreadTx();
            } else {
                throw new IllegalArgumentException("Traversal is not bound to a JanusGraph Graph, but: " + graph);
            }
        }
        if (tx == null) {
            throw new IllegalArgumentException("Not a valid start step for a JanusGraph traversal: " + traversal);
        }
        if (tx.isOpen()) {
            return tx;
        }
        return ((StandardJanusGraphTx)tx).getNextTx();
    }

    public static Step<?, ?> findMostOuterEligibleStart(Step<?, ?> step) {
        Step resultStep = step;
        Step nextStep = step.getTraversal().getParent().asStep();
        while (!(nextStep instanceof EmptyStep) && JanusGraphTraversalUtil.isMultiQueryCompatibleParent(nextStep)) {
            resultStep = nextStep;
            if (!JanusGraphTraversalUtil.isStartStep(nextStep)) break;
            nextStep = nextStep.getTraversal().getParent().asStep();
        }
        return resultStep;
    }

    public static boolean isMultiQueryCompatibleParent(Step<?, ?> step) {
        for (Class<? extends TraversalParent> allowedParentClass : MULTIQUERY_COMPATIBLE_PARENTS) {
            if (!allowedParentClass.isInstance(step)) continue;
            return true;
        }
        return false;
    }

    public static MultiQueryPositions getAllMultiQueryPositionsForMultiQueriable(MultiQueriable<?, ?> multiQueriable, boolean multiNestedRepeatEligible, boolean multiNestedRepeatNextIterationEligible) {
        MultiQueryPositions multiQueryPositions;
        block7: {
            RepeatStep parentRepeatStep;
            block8: {
                multiQueryPositions = new MultiQueryPositions();
                if (!JanusGraphTraversalUtil.isStartStep(multiQueriable)) {
                    JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(multiQueriable).ifPresent(step -> multiQueryPositions.currentLoopMultiQueryStepLocations.add((Step)step));
                    return multiQueryPositions;
                }
                MultiQueriable<?, ?> currentStep = multiQueriable;
                boolean parentRepeatIsUsed = false;
                do {
                    MultiQueriable<?, ?> previousStep = currentStep;
                    Step parentStep = (currentStep = JanusGraphTraversalUtil.findMostOuterEligibleStart(currentStep)).getTraversal().getParent().asStep();
                    if (!(parentStep instanceof RepeatStep) || currentStep != previousStep && !JanusGraphTraversalUtil.isStartStep(currentStep)) {
                        if (!parentRepeatIsUsed) {
                            JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(currentStep).ifPresent(step -> multiQueryPositions.currentLoopMultiQueryStepLocations.add((Step)step));
                        }
                        return multiQueryPositions;
                    }
                    parentRepeatStep = (RepeatStep)parentStep;
                    if (!parentRepeatIsUsed) {
                        JanusGraphTraversalUtil.getEndMultiQueryPosition(parentRepeatStep.getRepeatTraversal()).ifPresent(step -> {
                            multiQueryPositions.nextLoopMultiQueryStepLocation = step;
                        });
                        parentRepeatIsUsed = true;
                    } else if (multiNestedRepeatNextIterationEligible) {
                        JanusGraphTraversalUtil.getEndMultiQueryPosition(parentRepeatStep.getRepeatTraversal()).ifPresent(step -> multiQueryPositions.firstLoopMultiQueryStepLocations.add((Step)step));
                    }
                    Traversal.Admin traversal = currentStep.getTraversal();
                    if (traversal != parentRepeatStep.getRepeatTraversal() && (!parentRepeatStep.emitFirst || traversal != parentRepeatStep.getEmitTraversal()) && (!parentRepeatStep.untilFirst || traversal != parentRepeatStep.getUntilTraversal())) break block7;
                    if (!JanusGraphTraversalUtil.isStartStep(parentRepeatStep)) break block8;
                    currentStep = JanusGraphTraversalUtil.findMostOuterEligibleStart(parentRepeatStep);
                    JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(currentStep).ifPresent(step -> multiQueryPositions.firstLoopMultiQueryStepLocations.add((Step)step));
                } while (multiNestedRepeatEligible);
                return multiQueryPositions;
            }
            JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(parentRepeatStep).ifPresent(step -> multiQueryPositions.firstLoopMultiQueryStepLocations.add((Step)step));
            return multiQueryPositions;
        }
        return multiQueryPositions;
    }

    public static Optional<Step> getEndMultiQueryPosition(Traversal.Admin repeatTraversal) {
        return repeatTraversal == null ? Optional.empty() : JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(repeatTraversal.getEndStep());
    }

    public static Optional<Step> getLocalMultiQueryPositionForStep(Step<?, ?> step) {
        Step currentStep = step;
        Step previousStep = step.getPreviousStep();
        while (previousStep instanceof SideEffectStep || previousStep instanceof ProfileStep) {
            currentStep = previousStep;
            previousStep = previousStep.getPreviousStep();
        }
        if (previousStep instanceof NoOpBarrierStep) {
            return Optional.of(previousStep);
        }
        if (currentStep instanceof EmptyStep || currentStep instanceof StartStep) {
            return Optional.empty();
        }
        return Optional.of(currentStep);
    }

    public static Optional<Integer> getLocalNonMultiQueryProvidedBatchSize(MultiQueriable<?, ?> multiQueriable) {
        Optional<Step> optionalPosition = JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(multiQueriable);
        if (!optionalPosition.isPresent()) {
            return Optional.empty();
        }
        Step step = optionalPosition.get();
        if (!(step instanceof NoOpBarrierStep)) {
            return Optional.empty();
        }
        NoOpBarrierStep noOpBarrierStep = (NoOpBarrierStep)step;
        Step previousStep = noOpBarrierStep.getPreviousStep();
        if (previousStep instanceof JanusGraphMultiQueryStep && ((JanusGraphMultiQueryStep)previousStep).getGeneratedBarrierStep() == noOpBarrierStep) {
            return Optional.empty();
        }
        return Optional.of(noOpBarrierStep.getMaxBarrierSize());
    }

    public static boolean isStartStep(Step<?, ?> step) {
        Step startStep = step;
        while ((startStep = startStep.getPreviousStep()) instanceof JanusGraphMultiQueryStep || startStep instanceof NoOpBarrierStep || startStep instanceof IdentityStep || startStep instanceof SideEffectStep || startStep instanceof ProfileStep) {
        }
        return startStep instanceof EmptyStep || startStep instanceof StartStep;
    }

    public static boolean isLegalMultiQueryPosition(Step<?, ?> step) {
        if (step.getTraversal().getTraverserRequirements().contains(TraverserRequirement.PATH)) {
            return false;
        }
        boolean labeledPath = false;
        Step currentStep = step.getTraversal().getStartStep();
        while (!currentStep.equals(step, true)) {
            if (step instanceof PathProcessor) {
                Set keepLabels = ((PathProcessor)step).getKeepLabels();
                labeledPath &= keepLabels == null || !keepLabels.isEmpty();
            }
            labeledPath |= !step.getLabels().isEmpty();
            currentStep = currentStep.getNextStep();
        }
        return !labeledPath;
    }

    public static <S> Optional<S> getPreviousStepOfClass(Class<S> stepClass, Step<?, ?> start) {
        Step currentStep;
        for (currentStep = start; currentStep != null && !currentStep.getClass().equals(stepClass) && !(currentStep instanceof EmptyStep); currentStep = currentStep.getPreviousStep()) {
        }
        return currentStep != null && currentStep.getClass().equals(stepClass) ? Optional.of(currentStep) : Optional.empty();
    }

    public static List<Step> getSteps(Predicate<Step> predicate, Traversal.Admin<?, ?> traversal) {
        return traversal.getSteps().stream().filter(predicate).collect(Collectors.toList());
    }
}

