/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractEdge;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class CacheEdge
extends AbstractEdge {
    private final Entry data;

    public CacheEdge(long id, EdgeLabel label, InternalVertex start, InternalVertex end, Entry data) {
        super(id, label, start.it(), end.it());
        assert (data != null);
        this.data = data;
    }

    public Direction getVertexCentricDirection() {
        RelationCache cache = this.data.getCache();
        Preconditions.checkNotNull((Object)cache, (Object)"Cache is null");
        return cache.direction;
    }

    @Override
    public InternalRelation it() {
        InternalRelation it = null;
        InternalVertex startVertex = this.getVertex(0);
        if (startVertex.hasAddedRelations() && startVertex.hasRemovedRelations()) {
            long id = super.longId();
            Iterable<InternalRelation> added = startVertex.getAddedRelations((Predicate<InternalRelation>)((Predicate)internalRelation -> internalRelation instanceof StandardEdge && ((StandardEdge)internalRelation).getPreviousID() == id));
            assert (Iterables.size(added) <= 1 || this.isLoop() && Iterables.size(added) == 2);
            it = (InternalRelation)Iterables.getFirst(added, null);
        }
        if (it != null) {
            return it;
        }
        return super.it();
    }

    private void copyProperties(InternalRelation to) {
        for (LongObjectCursor<Object> entry : this.getPropertyMap()) {
            PropertyKey type = this.tx().getExistingPropertyKey(entry.key);
            if (type instanceof ImplicitKey) continue;
            to.setPropertyDirect(type, entry.value);
        }
    }

    private synchronized InternalRelation update() {
        StandardEdge copy = new StandardEdge(super.longId(), this.edgeLabel(), this.getVertex(0), this.getVertex(1), 2);
        this.copyProperties(copy);
        copy.remove();
        Long id = this.type.getConsistencyModifier() != ConsistencyModifier.FORK ? Long.valueOf(this.longId()) : null;
        StandardEdge u = (StandardEdge)this.tx().addEdge(id, this.getVertex(0), this.getVertex(1), this.edgeLabel());
        u.setPreviousID(this.longId());
        this.copyProperties(u);
        return u;
    }

    private RelationCache getPropertyMap() {
        RelationCache map = this.data.getCache();
        if (map == null || !map.hasProperties()) {
            map = RelationConstructor.readRelationCache(this.data, this.tx());
        }
        return map;
    }

    @Override
    public <O> O getValueDirect(PropertyKey key) {
        return this.getPropertyMap().get(key.longId());
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeysDirect() {
        RelationCache map = this.getPropertyMap();
        ArrayList<PropertyKey> types = new ArrayList<PropertyKey>(map.numProperties());
        for (LongObjectCursor<Object> entry : map) {
            types.add(this.tx().getExistingPropertyKey(entry.key));
        }
        return types;
    }

    @Override
    public void setPropertyDirect(PropertyKey key, Object value) {
        this.update().setPropertyDirect(key, value);
    }

    @Override
    public <O> O removePropertyDirect(PropertyKey key) {
        return this.update().removePropertyDirect(key);
    }

    @Override
    public byte getLifeCycle() {
        InternalVertex startVertex = this.getVertex(0);
        return (byte)((startVertex.hasRemovedRelations() || startVertex.isRemoved()) && this.tx().isRemovedRelation(super.longId()) ? 6 : 2);
    }

    @Override
    public void remove() {
        if (!this.isRemoved()) {
            this.tx().removeRelation(this);
        }
    }
}

