/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.profile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class SimpleQueryProfiler
implements QueryProfiler,
Iterable<SimpleQueryProfiler> {
    private final List<SimpleQueryProfiler> nestedProfilers = new ArrayList<SimpleQueryProfiler>();
    private final Map<String, Object> annotations = new HashMap<String, Object>();
    private final String groupName;
    private long resultSize = 0L;
    private long startTimeNs = 0L;
    private boolean runningTimer = false;
    private long measuredTimeNs = 0L;

    public SimpleQueryProfiler() {
        this("__root");
    }

    public SimpleQueryProfiler(String groupName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)groupName));
        this.groupName = groupName;
    }

    @Override
    public QueryProfiler addNested(String groupName, boolean hasSiblings) {
        SimpleQueryProfiler nested = new SimpleQueryProfiler(groupName);
        this.nestedProfilers.add(nested);
        return nested;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public QueryProfiler setAnnotation(String key, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"Must provide a key");
        this.annotations.put(key, this.convert(value));
        return this;
    }

    private Object convert(Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Value may not be null");
        return value;
    }

    @Override
    public void startTimer() {
        Preconditions.checkArgument((!this.runningTimer ? 1 : 0) != 0, (Object)"A timer is already running");
        this.startTimeNs = System.nanoTime();
        this.runningTimer = true;
    }

    @Override
    public void stopTimer() {
        Preconditions.checkArgument((boolean)this.runningTimer, (Object)"No timer running");
        this.measuredTimeNs += System.nanoTime() - this.startTimeNs;
        this.runningTimer = false;
    }

    @Override
    public void setResultSize(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0);
        this.resultSize = size;
    }

    @Override
    public Iterator<SimpleQueryProfiler> iterator() {
        return this.nestedProfilers.iterator();
    }

    public <O> O getAnnotation(String key) {
        return (O)this.annotations.get(key);
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public long getTotalTime() {
        return this.measuredTimeNs;
    }

    public long getResultSize() {
        return this.resultSize;
    }
}

