/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.index;

import java.util.Set;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.index.AbstractIndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.ApproximateIndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.BruteForceIndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.IndexSelectionStrategy;
import org.janusgraph.graphdb.types.IndexType;

public class ThresholdBasedIndexSelectionStrategy
extends AbstractIndexSelectionStrategy {
    public static final String NAME = "threshold-based";
    private final int threshold;
    public static final ConfigOption<Integer> INDEX_SELECT_BRUTE_FORCE_THRESHOLD = new ConfigOption<Integer>(GraphDatabaseConfiguration.QUERY_NS, "index-select-threshold", "Threshold of deciding whether to use brute force enumeration algorithm or fast approximation algorithm for selecting suitable indexes. Selecting optimal indexes for a query is a NP-complete set cover problem. When number of suitable index candidates is no larger than threshold, JanusGraph uses brute force search with exponential time complexity to ensure the best combination of indexes is selected. Only effective when `threshold-based` index select strategy is chosen.", ConfigOption.Type.MASKABLE, 10);
    private final IndexSelectionStrategy usedIfLessOrEqualThreshold;
    private final IndexSelectionStrategy usedIfGreaterThanThreshold;

    public ThresholdBasedIndexSelectionStrategy(Configuration config) {
        super(config);
        this.threshold = config.get(INDEX_SELECT_BRUTE_FORCE_THRESHOLD, new String[0]);
        this.usedIfLessOrEqualThreshold = new BruteForceIndexSelectionStrategy(config);
        this.usedIfGreaterThanThreshold = new ApproximateIndexSelectionStrategy(config);
    }

    @Override
    public IndexSelectionStrategy.SelectedIndexQuery selectIndices(Set<IndexType> indexCandidates, MultiCondition<JanusGraphElement> conditions, Set<Condition> coveredClauses, OrderList orders, IndexSerializer serializer) {
        IndexSelectionStrategy preferredStrategy = indexCandidates.size() <= this.threshold ? this.usedIfLessOrEqualThreshold : this.usedIfGreaterThanThreshold;
        return preferredStrategy.selectIndices(indexCandidates, conditions, coveredClauses, orders, serializer);
    }
}

