/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;

public class ConditionUtil {
    public static <E extends JanusGraphElement> Condition<E> literalTransformation(Condition<E> condition, final Function<Condition<E>, Condition<E>> transformation) {
        return ConditionUtil.transformation(condition, new Function<Condition<E>, Condition<E>>(){

            @Nullable
            public Condition<E> apply(Condition<E> cond) {
                if (cond.getType() == Condition.Type.LITERAL) {
                    return (Condition)transformation.apply(cond);
                }
                return null;
            }
        });
    }

    public static <E extends JanusGraphElement> Condition<E> transformation(Condition<E> condition, Function<Condition<E>, Condition<E>> transformation) {
        Condition transformed = (Condition)transformation.apply(condition);
        if (transformed != null) {
            return transformed;
        }
        if (condition.getType() == Condition.Type.LITERAL) {
            return condition;
        }
        if (condition instanceof Not) {
            return Not.of(ConditionUtil.transformation(((Not)condition).getChild(), transformation));
        }
        if (condition instanceof And) {
            And<E> newAnd = new And<E>(condition.numChildren());
            for (Condition<E> child : condition.getChildren()) {
                newAnd.add(ConditionUtil.transformation(child, transformation));
            }
            return newAnd;
        }
        if (condition instanceof Or) {
            Or<E> newOr = new Or<E>(condition.numChildren());
            for (Condition<E> child : condition.getChildren()) {
                newOr.add(ConditionUtil.transformation(child, transformation));
            }
            return newOr;
        }
        throw new IllegalArgumentException("Unexpected condition type: " + condition);
    }

    public static boolean containsType(Condition<?> condition, Condition.Type type) {
        if (condition.getType() == type) {
            return true;
        }
        if (condition.numChildren() > 0) {
            for (Condition<?> child : condition.getChildren()) {
                if (!ConditionUtil.containsType(child, type)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E extends JanusGraphElement> void traversal(Condition<E> condition, Predicate<Condition<E>> evaluator) {
        Preconditions.checkArgument((!evaluator.test(condition) || condition.getType() == Condition.Type.LITERAL || condition instanceof Not || condition instanceof MultiCondition ? 1 : 0) != 0, (String)"Unexpected condition type: %s", condition);
        if (condition instanceof Not) {
            ConditionUtil.traversal(((Not)condition).getChild(), evaluator);
        } else if (condition instanceof MultiCondition) {
            condition.getChildren().forEach(child -> ConditionUtil.traversal(child, evaluator));
        }
    }
}

