/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.job;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.index.IndexUpdate;
import org.janusgraph.graphdb.database.management.RelationTypeIndexWrapper;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.olap.QueryContainer;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.olap.job.IndexUpdateJob;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.util.StringUtils;

public class IndexRepairJob
extends IndexUpdateJob
implements VertexScanJob {
    public static final String ADDED_RECORDS_COUNT = "adds";
    public static final String DOCUMENT_UPDATES_COUNT = "doc-updates";
    private Map<String, Map<String, List<IndexEntry>>> documentsPerStore = new HashMap<String, Map<String, List<IndexEntry>>>();

    public IndexRepairJob() {
    }

    protected IndexRepairJob(IndexRepairJob job) {
        super(job);
    }

    public IndexRepairJob(String indexName, String indexType) {
        super(indexName, indexType);
    }

    @Override
    protected void validateIndexStatus() {
        String invalidIndexHint;
        JanusGraphSchemaVertex schemaVertex = this.managementSystem.getSchemaVertex(this.index);
        Set<SchemaStatus> acceptableStatuses = SchemaAction.REINDEX.getApplicableStatus();
        boolean isValidIndex = true;
        if (this.index instanceof RelationTypeIndex || this.index instanceof JanusGraphIndex && ((JanusGraphIndex)this.index).isCompositeIndex()) {
            SchemaStatus actualStatus = schemaVertex.getStatus();
            isValidIndex = acceptableStatuses.contains((Object)actualStatus);
            invalidIndexHint = String.format("The index has status %s, but one of %s is required", new Object[]{actualStatus, acceptableStatuses});
        } else {
            Preconditions.checkArgument((boolean)(this.index instanceof JanusGraphIndex), (String)"Unexpected index: %s", (Object)this.index);
            JanusGraphIndex graphIndex = (JanusGraphIndex)this.index;
            Preconditions.checkArgument((boolean)graphIndex.isMixedIndex());
            HashMap<String, SchemaStatus> invalidKeyStatuses = new HashMap<String, SchemaStatus>();
            int acceptableFields = 0;
            for (PropertyKey key : graphIndex.getFieldKeys()) {
                SchemaStatus status = graphIndex.getIndexStatus(key);
                if (status != SchemaStatus.DISABLED && !acceptableStatuses.contains((Object)status)) {
                    isValidIndex = false;
                    invalidKeyStatuses.put(key.name(), status);
                    this.log.warn("Index {} has key {} in an invalid status {}", new Object[]{this.index, key, status});
                }
                if (!acceptableStatuses.contains((Object)status)) continue;
                ++acceptableFields;
            }
            invalidIndexHint = String.format("The following index keys have invalid status: %s (status must be one of %s)", StringUtils.join(invalidKeyStatuses, (String)" has status ", (String)","), acceptableStatuses);
            if (isValidIndex && acceptableFields == 0) {
                isValidIndex = false;
                invalidIndexHint = "The index does not contain any valid keys";
            }
        }
        Preconditions.checkArgument((boolean)isValidIndex, (String)"The index %s is in an invalid state and cannot be indexed. %s", (Object)this.indexName, (Object)invalidIndexHint);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Index " + this.index.name() + " is valid for re-indexing");
        }
    }

    @Override
    public void process(JanusGraphVertex vertex, ScanMetrics metrics) {
        block21: {
            try {
                BackendTransaction mutator = this.writeTx.getTxHandle();
                if (this.index instanceof RelationTypeIndex) {
                    RelationTypeIndexWrapper wrapper = (RelationTypeIndexWrapper)this.index;
                    InternalRelationType wrappedType = wrapper.getWrappedType();
                    EdgeSerializer edgeSerializer = this.writeTx.getEdgeSerializer();
                    ArrayList<Entry> outAdditions = new ArrayList<Entry>();
                    HashMap<StaticBuffer, List> inAdditionsMap = new HashMap<StaticBuffer, List>();
                    for (JanusGraphRelation relation : vertex.query().types(new String[]{this.indexRelationTypeName}).direction(Direction.OUT).relations()) {
                        InternalRelation janusgraphRelation = (InternalRelation)relation;
                        for (int pos = 0; pos < janusgraphRelation.getArity(); ++pos) {
                            if (!wrappedType.isUnidirected(Direction.BOTH) && !wrappedType.isUnidirected(EdgeDirection.fromPosition(pos))) continue;
                            StaticArrayEntry entry = edgeSerializer.writeRelation(janusgraphRelation, wrappedType, pos, this.writeTx);
                            if (pos == 0) {
                                outAdditions.add(entry);
                                continue;
                            }
                            assert (pos == 1);
                            InternalVertex otherVertex = janusgraphRelation.getVertex(1);
                            StaticBuffer otherVertexKey = this.writeTx.getIdInspector().getKey(otherVertex.id());
                            inAdditionsMap.computeIfAbsent(otherVertexKey, k -> new ArrayList()).add(entry);
                        }
                    }
                    StaticBuffer vertexKey = this.writeTx.getIdInspector().getKey(vertex.id());
                    mutator.mutateEdges(vertexKey, outAdditions, KCVSCache.NO_DELETIONS);
                    int totalInAdditions = 0;
                    for (Map.Entry entry : inAdditionsMap.entrySet()) {
                        StaticBuffer otherVertexKey = (StaticBuffer)entry.getKey();
                        List inAdditions = (List)entry.getValue();
                        totalInAdditions += inAdditions.size();
                        mutator.mutateEdges(otherVertexKey, inAdditions, KCVSCache.NO_DELETIONS);
                    }
                    metrics.incrementCustom(ADDED_RECORDS_COUNT, outAdditions.size() + totalInAdditions);
                    break block21;
                }
                if (this.index instanceof JanusGraphIndex) {
                    Iterator<JanusGraphElement> elements;
                    IndexType indexType = this.managementSystem.getSchemaVertex(this.index).asIndexType();
                    assert (indexType != null);
                    IndexSerializer indexSerializer = this.graph.getIndexSerializer();
                    switch (indexType.getElement()) {
                        case VERTEX: {
                            elements = Collections.singletonList(vertex).iterator();
                            break;
                        }
                        case PROPERTY: {
                            elements = IndexRepairJob.addIndexSchemaConstraint(vertex.query(), indexType).properties().iterator();
                            break;
                        }
                        case EDGE: {
                            elements = ((JanusGraphVertexQuery)IndexRepairJob.addIndexSchemaConstraint(vertex.query().direction(Direction.OUT), indexType)).edges().iterator();
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected category: " + (Object)((Object)indexType.getElement())));
                        }
                    }
                    if (indexType.isCompositeIndex()) {
                        while (elements.hasNext()) {
                            JanusGraphElement element = elements.next();
                            Set<IndexUpdate<StaticBuffer, Entry>> updates = indexSerializer.reindexElement(element, (CompositeIndexType)indexType);
                            for (final IndexUpdate<StaticBuffer, Entry> update : updates) {
                                this.log.debug("Mutating index {}: {}", (Object)indexType, (Object)update.getEntry());
                                mutator.mutateIndex(update.getKey(), (List<Entry>)new ArrayList<Entry>(1){
                                    {
                                        super(x0);
                                        this.add(update.getEntry());
                                    }
                                }, KCVSCache.NO_DELETIONS);
                                metrics.incrementCustom(ADDED_RECORDS_COUNT);
                            }
                        }
                    } else {
                        assert (indexType.isMixedIndex());
                        while (elements.hasNext()) {
                            JanusGraphElement element = elements.next();
                            if (!indexSerializer.reindexElement(element, (MixedIndexType)indexType, this.documentsPerStore)) continue;
                            metrics.incrementCustom(DOCUMENT_UPDATES_COUNT);
                        }
                    }
                    break block21;
                }
                throw new UnsupportedOperationException("Unsupported index found: " + this.index);
            }
            catch (Exception e) {
                this.managementSystem.rollback();
                this.writeTx.rollback();
                metrics.incrementCustom("failed-tx");
                throw new JanusGraphException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        try {
            if (this.index instanceof JanusGraphIndex) {
                BackendTransaction mutator = this.writeTx.getTxHandle();
                IndexType indexType = this.managementSystem.getSchemaVertex(this.index).asIndexType();
                if (indexType.isMixedIndex() && this.documentsPerStore.size() > 0) {
                    mutator.getIndexTransaction(indexType.getBackingIndexName()).restore(this.documentsPerStore);
                    this.documentsPerStore = new HashMap<String, Map<String, List<IndexEntry>>>();
                }
            }
        }
        catch (BackendException e) {
            throw new JanusGraphException(e.getMessage(), e);
        }
        finally {
            super.workerIterationEnd(metrics);
        }
    }

    @Override
    public void getQueries(QueryContainer queries) {
        if (this.index instanceof RelationTypeIndex) {
            ((QueryContainer.QueryBuilder)queries.addQuery().types(this.indexRelationTypeName)).direction(Direction.OUT).relations();
        } else if (this.index instanceof JanusGraphIndex) {
            IndexType indexType = this.managementSystem.getSchemaVertex(this.index).asIndexType();
            switch (indexType.getElement()) {
                case PROPERTY: {
                    IndexRepairJob.addIndexSchemaConstraint(queries.addQuery(), indexType).properties();
                    break;
                }
                case VERTEX: {
                    queries.addQuery().properties();
                    queries.addQuery().type(BaseLabel.VertexLabelEdge).direction(Direction.OUT).edges();
                    break;
                }
                case EDGE: {
                    indexType.hasSchemaTypeConstraint();
                    IndexRepairJob.addIndexSchemaConstraint(queries.addQuery().direction(Direction.OUT), indexType).edges();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected category: " + (Object)((Object)indexType.getElement())));
                }
            }
        } else {
            throw new UnsupportedOperationException("Unsupported index found: " + this.index);
        }
    }

    @Override
    public IndexRepairJob clone() {
        return new IndexRepairJob(this);
    }

    private static <Q extends BaseVertexQuery> Q addIndexSchemaConstraint(Q query, IndexType indexType) {
        if (indexType.hasSchemaTypeConstraint()) {
            JanusGraphSchemaType constraint = indexType.getSchemaTypeConstraint();
            Preconditions.checkArgument((boolean)(constraint instanceof RelationType), (String)"Expected constraint to be a relation type: %s", (Object)constraint);
            query.types((RelationType)constraint);
        }
        return query;
    }
}

