/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.olap.computer.VertexMemoryHandler;

public class FulgoraVertexProperty<V>
implements JanusGraphVertexProperty<V> {
    private final VertexMemoryHandler mixinParent;
    private final JanusGraphVertex vertex;
    private final String key;
    private final V value;
    private boolean isRemoved = false;

    public FulgoraVertexProperty(VertexMemoryHandler mixinParent, JanusGraphVertex vertex, String key, V value) {
        this.mixinParent = mixinParent;
        this.vertex = vertex;
        this.key = key;
        this.value = value;
    }

    @Override
    public String key() {
        return this.key;
    }

    public V value() throws NoSuchElementException {
        return this.value;
    }

    public boolean isPresent() {
        return true;
    }

    @Override
    public JanusGraphVertex element() {
        return this.vertex;
    }

    @Override
    public void remove() {
        this.mixinParent.removeKey(this.key);
        this.isRemoved = true;
    }

    @Override
    public Object id() {
        return null;
    }

    @Override
    public long longId() {
        throw new IllegalStateException("An id has not been set for this property");
    }

    @Override
    public boolean hasId() {
        return false;
    }

    public <A> Property<A> property(String s, A v) {
        throw new UnsupportedOperationException();
    }

    public <A> A valueOrNull(PropertyKey key) {
        return (A)this.property(key.name()).orElse(null);
    }

    @Override
    public boolean isNew() {
        return !this.isRemoved;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    public <A> A value(String key) {
        throw Property.Exceptions.propertyDoesNotExist((Element)this, (String)key);
    }

    @Override
    public RelationType getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Direction direction(Vertex vertex) {
        if (this.isIncidentOn(vertex)) {
            return Direction.OUT;
        }
        throw new IllegalArgumentException("Property is not incident on vertex");
    }

    @Override
    public boolean isIncidentOn(Vertex vertex) {
        return this.vertex.equals(vertex);
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public boolean isEdge() {
        return false;
    }

    public <A> Iterator<Property<A>> properties(String ... propertyKeys) {
        return Collections.emptyIterator();
    }
}

