/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.util.HashingUtil;
import org.janusgraph.graphdb.database.IndexRecordEntry;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.index.IndexMutationType;
import org.janusgraph.graphdb.database.index.IndexUpdate;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.vertices.CacheVertex;

public class StaleIndexRecordUtil {
    private static final String ANY_UPDATE_KEY = "_";
    private static final Object ANY_UPDATE_VALUE = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRemoveVertexFromGraphIndex(Object vertexId, Map<String, Object> indexRecordPropertyValues, JanusGraph graph, String graphIndexName) throws BackendException {
        block8: {
            ManagementSystem managementSystem = (ManagementSystem)graph.openManagement();
            try {
                JanusGraphIndex index = managementSystem.getGraphIndex(graphIndexName);
                PropertyKey[] propertyKeys = index.getFieldKeys();
                if (index.isCompositeIndex()) {
                    IndexRecordEntry[] indexRecord = StaleIndexRecordUtil.toCompositeIndexRecord(propertyKeys, indexRecordPropertyValues);
                    StandardJanusGraphTx tx = (StandardJanusGraphTx)graph.newTransaction();
                    try {
                        CacheVertex elementToBeRemoved = new CacheVertex(tx, vertexId, 1);
                        StaleIndexRecordUtil.forceRemoveElementFromCompositeIndex(elementToBeRemoved, indexRecord, (StandardJanusGraph)graph, index, managementSystem);
                        break block8;
                    }
                    finally {
                        tx.rollback();
                    }
                }
                if (index.isMixedIndex()) {
                    IndexRecordEntry[] indexRecord = StaleIndexRecordUtil.toMixedIndexRecord(propertyKeys, indexRecordPropertyValues);
                    StaleIndexRecordUtil.forceRemoveElementFromMixedGraphIndex(vertexId, indexRecord, (StandardJanusGraph)graph, index, managementSystem);
                }
            }
            finally {
                managementSystem.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRemoveElementFromGraphIndex(JanusGraphElement elementToRemoveFromIndex, IndexRecordEntry[] indexRecord, StandardJanusGraph graph, String graphIndexName) throws BackendException {
        ManagementSystem managementSystem = (ManagementSystem)graph.openManagement();
        try {
            JanusGraphIndex index = managementSystem.getGraphIndex(graphIndexName);
            if (index.isCompositeIndex()) {
                StaleIndexRecordUtil.forceRemoveElementFromCompositeIndex(elementToRemoveFromIndex, indexRecord, graph, index, managementSystem);
            } else if (index.isMixedIndex()) {
                StaleIndexRecordUtil.forceRemoveElementFromMixedGraphIndex(elementToRemoveFromIndex.id(), indexRecord, graph, index, managementSystem);
            }
        }
        finally {
            managementSystem.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRemoveElementFromMixedIndex(Object elementId, Map<String, Object> indexRecordPropertyValues, JanusGraph graph, String mixedIndexName) throws BackendException {
        ManagementSystem managementSystem = (ManagementSystem)graph.openManagement();
        try {
            JanusGraphIndex index = managementSystem.getGraphIndex(mixedIndexName);
            PropertyKey[] propertyKeys = index.getFieldKeys();
            IndexRecordEntry[] indexRecord = StaleIndexRecordUtil.toMixedIndexRecord(propertyKeys, indexRecordPropertyValues);
            StaleIndexRecordUtil.forceRemoveElementFromMixedGraphIndex(elementId, indexRecord, (StandardJanusGraph)graph, index, managementSystem);
        }
        finally {
            managementSystem.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRemoveElementFromMixedIndex(Object elementId, IndexRecordEntry[] indexRecord, JanusGraph graph, String mixedIndexName) throws BackendException {
        ManagementSystem managementSystem = (ManagementSystem)graph.openManagement();
        try {
            JanusGraphIndex index = managementSystem.getGraphIndex(mixedIndexName);
            StaleIndexRecordUtil.forceRemoveElementFromMixedGraphIndex(elementId, indexRecord, (StandardJanusGraph)graph, index, managementSystem);
        }
        finally {
            managementSystem.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRemoveElementFromMixedIndex(Object elementId, JanusGraph graph, String mixedIndexName) throws BackendException {
        ManagementSystem managementSystem = (ManagementSystem)graph.openManagement();
        try {
            JanusGraphIndex index = managementSystem.getGraphIndex(mixedIndexName);
            StaleIndexRecordUtil.forceRemoveElementFullyFromMixedGraphIndex(elementId, (StandardJanusGraph)graph, index, managementSystem);
        }
        finally {
            managementSystem.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceRemoveElementFromCompositeIndex(JanusGraphElement elementToRemoveFromIndex, IndexRecordEntry[] indexRecord, StandardJanusGraph graph, JanusGraphIndex index, ManagementSystem managementSystem) throws BackendException {
        StaleIndexRecordUtil.verifyIndexIsComposite(index);
        Serializer serializer = graph.getDataSerializer();
        boolean hashKeys = graph.getIndexSerializer().isHashKeys();
        HashingUtil.HashLength hashLength = graph.getIndexSerializer().getHashLength();
        JanusGraphSchemaVertex indexSchemaVertex = managementSystem.getSchemaVertex(index);
        CompositeIndexType compositeIndexType = (CompositeIndexType)indexSchemaVertex.asIndexType();
        IndexUpdate<StaticBuffer, Entry> update = IndexRecordUtil.getCompositeIndexUpdate(compositeIndexType, IndexMutationType.DELETE, indexRecord, elementToRemoveFromIndex, serializer, hashKeys, hashLength);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)graph.newTransaction();
        BackendTransaction transaction = tx.getTxHandle();
        try {
            transaction.mutateIndex(update.getKey(), Collections.emptyList(), Collections.singletonList(update.getEntry()));
        }
        finally {
            try {
                transaction.commit();
            }
            finally {
                tx.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceRemoveElementFromMixedGraphIndex(Object elementIdToRemoveFromIndex, IndexRecordEntry[] indexRecord, StandardJanusGraph graph, JanusGraphIndex index, ManagementSystem managementSystem) throws BackendException {
        StaleIndexRecordUtil.verifyIndexIsMixed(index);
        JanusGraphSchemaVertex indexSchemaVertex = managementSystem.getSchemaVertex(index);
        MixedIndexType indexType = (MixedIndexType)indexSchemaVertex.asIndexType();
        String elementKey = IndexRecordUtil.element2String(elementIdToRemoveFromIndex);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)graph.newTransaction();
        BackendTransaction transaction = tx.getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(indexType.getBackingIndexName());
        try {
            for (IndexRecordEntry indexRecordEntry : indexRecord) {
                indexTransaction.delete(indexType.getStoreName(), elementKey, IndexRecordUtil.key2Field(indexType, indexRecordEntry.getKey()), indexRecordEntry.getValue(), false);
            }
        }
        finally {
            try {
                transaction.commit();
            }
            finally {
                tx.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceRemoveElementFullyFromMixedGraphIndex(Object elementIdToRemoveFromIndex, StandardJanusGraph graph, JanusGraphIndex index, ManagementSystem managementSystem) throws BackendException {
        StaleIndexRecordUtil.verifyIndexIsMixed(index);
        JanusGraphSchemaVertex indexSchemaVertex = managementSystem.getSchemaVertex(index);
        MixedIndexType indexType = (MixedIndexType)indexSchemaVertex.asIndexType();
        String elementKey = IndexRecordUtil.element2String(elementIdToRemoveFromIndex);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)graph.newTransaction();
        BackendTransaction transaction = tx.getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(indexType.getBackingIndexName());
        try {
            indexTransaction.delete(indexType.getStoreName(), elementKey, ANY_UPDATE_KEY, ANY_UPDATE_VALUE, true);
        }
        finally {
            try {
                transaction.commit();
            }
            finally {
                tx.commit();
            }
        }
    }

    private static IndexRecordEntry[] toCompositeIndexRecord(PropertyKey[] propertyKeys, Map<String, Object> indexRecordPropertyValues) {
        if (indexRecordPropertyValues.size() != propertyKeys.length) {
            throw new IllegalArgumentException("indexRecordPropertyValues contains " + indexRecordPropertyValues.size() + " properties but provided index has " + propertyKeys.length + " indexed properties. It is necessary to include all but only indexed properties in indexRecordPropertyValues.");
        }
        IndexRecordEntry[] indexRecord = new IndexRecordEntry[propertyKeys.length];
        for (int i = 0; i < propertyKeys.length; ++i) {
            PropertyKey propertyKey = propertyKeys[i];
            String propertyKeyName = propertyKey.name();
            if (!indexRecordPropertyValues.containsKey(propertyKeyName)) {
                throw new IllegalArgumentException("indexRecordPropertyValues doesn't contain property " + propertyKeyName + " but provided index has this property. It is necessary to include all but only indexed properties in indexRecordPropertyValues.");
            }
            Object propertyValue = indexRecordPropertyValues.get(propertyKeyName);
            long propertyKeyId = propertyKey.longId();
            indexRecord[i] = new IndexRecordEntry(propertyKeyId, propertyValue, propertyKey);
        }
        return indexRecord;
    }

    private static IndexRecordEntry[] toMixedIndexRecord(PropertyKey[] propertyKeys, Map<String, Object> indexRecordPropertyValues) {
        HashMap<String, PropertyKey> propertyKeyMap = new HashMap<String, PropertyKey>(propertyKeys.length);
        for (PropertyKey propertyKey : propertyKeys) {
            propertyKeyMap.put(propertyKey.name(), propertyKey);
        }
        IndexRecordEntry[] indexRecord = new IndexRecordEntry[indexRecordPropertyValues.size()];
        Iterator<Map.Entry<String, Object>> recordPropertyIt = indexRecordPropertyValues.entrySet().iterator();
        for (int i = 0; i < indexRecord.length; ++i) {
            Map.Entry<String, Object> recordProperty = recordPropertyIt.next();
            String propertyName = recordProperty.getKey();
            PropertyKey propertyKey = (PropertyKey)propertyKeyMap.get(propertyName);
            if (propertyKey == null) {
                throw new IllegalArgumentException("indexRecordPropertyValues contains property " + propertyName + " which isn't presented in the index.");
            }
            long propertyKeyId = propertyKey.longId();
            indexRecord[i] = new IndexRecordEntry(propertyKeyId, recordProperty.getValue(), propertyKey);
        }
        return indexRecord;
    }

    private static void verifyIndexIsComposite(JanusGraphIndex index) {
        if (!index.isCompositeIndex()) {
            throw new IllegalArgumentException("Index [" + index.name() + "] is not a Composite index but a Composite index is expected");
        }
    }

    private static void verifyIndexIsMixed(JanusGraphIndex index) {
        if (!index.isMixedIndex()) {
            throw new IllegalArgumentException("Index [" + index.name() + "] is not a Mixed index but a Mixed index is expected");
        }
    }
}

