/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;

public class BooleanSerializer
implements OrderPreservingSerializer<Boolean> {
    @Override
    public Boolean read(ScanBuffer buffer) {
        return BooleanSerializer.decode(buffer.getByte());
    }

    @Override
    public void write(WriteBuffer out, Boolean attribute) {
        out.putByte(BooleanSerializer.encode(attribute));
    }

    @Override
    public Boolean readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Boolean attribute) {
        this.write(buffer, attribute);
    }

    @Override
    public Boolean convert(Object value) {
        if (value instanceof Number) {
            return BooleanSerializer.decode(((Number)value).byteValue());
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return null;
    }

    public static boolean decode(byte b) {
        switch (b) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + b);
    }

    public static byte encode(boolean b) {
        return (byte)(b ? 1 : 0);
    }
}

