/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util.backpressure;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.janusgraph.util.system.ExecuteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemaphoreProtectedReleaseQueryBackPressure
implements QueryBackPressure {
    private static final Logger log = LoggerFactory.getLogger(SemaphoreProtectedReleaseQueryBackPressure.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Runnable releaseNonBlocking;
    private final Semaphore semaphore;
    private volatile boolean hadWarningLogged;

    public SemaphoreProtectedReleaseQueryBackPressure(int backPressureLimit) {
        this.semaphore = new Semaphore(backPressureLimit, true);
        this.releaseNonBlocking = () -> {
            if (this.semaphore.availablePermits() < backPressureLimit) {
                this.semaphore.release();
            } else if (!this.hadWarningLogged) {
                log.warn("`releaseAfterQuery` is called more than once for some of the `acquireBeforeQuery` calls. This is a sign that the logic using this `QueryBackPressure` may not properly handle special (potentially exceptional) cases. {} will not trigger more releases than {}. This warning will be logged only once and it will be ignored for other `releaseAfterQuery` calls which attempt to add more permits than the configured limit.", (Object)SemaphoreProtectedReleaseQueryBackPressure.class.getSimpleName(), (Object)backPressureLimit);
                this.hadWarningLogged = true;
            }
        };
    }

    @Override
    public void acquireBeforeQuery() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JanusGraphException(e);
        }
    }

    @Override
    public void releaseAfterQuery() {
        this.executorService.execute(this.releaseNonBlocking);
    }

    @Override
    public void close() {
        ExecuteUtil.gracefulExecutorServiceShutdown(this.executorService, Long.MAX_VALUE);
    }

    int availablePermits() {
        return this.semaphore.availablePermits();
    }

    boolean hadWarningLogged() {
        return this.hadWarningLogged;
    }
}

