/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;

public class EntryArrayList
extends ArrayList<Entry>
implements EntryList {
    public static final int ENTRY_SIZE_ESTIMATE = 256;

    public EntryArrayList() {
    }

    public EntryArrayList(Collection<? extends Entry> c) {
        super(c);
    }

    public static EntryArrayList of(Iterator<? extends Entry> i) {
        EntryArrayList result = new EntryArrayList();
        i.forEachRemaining(result::add);
        return result;
    }

    public static EntryArrayList of(Iterable<? extends Entry> i) {
        EntryArrayList result;
        if (i instanceof Collection) {
            result = new EntryArrayList((Collection)i);
        } else {
            result = new EntryArrayList();
            i.forEach(result::add);
        }
        return result;
    }

    @Override
    public Iterator<Entry> reuseIterator() {
        return this.iterator();
    }

    @Override
    public int getByteSize() {
        return this.size() * 256;
    }
}

