/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.log.kcvs;

import java.util.ArrayList;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CacheTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.log.kcvs.ExternalPersistor;

public class ExternalCachePersistor
implements ExternalPersistor {
    private final KCVSCache kcvs;
    private final CacheTransaction tx;

    public ExternalCachePersistor(KCVSCache kcvs, CacheTransaction tx) {
        this.kcvs = kcvs;
        this.tx = tx;
    }

    @Override
    public void add(StaticBuffer key, Entry cell) {
        try {
            ArrayList<Entry> list = new ArrayList<Entry>(1);
            list.add(cell);
            this.kcvs.mutateEntries(key, list, KCVSCache.NO_DELETIONS, this.tx);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Unexpected storage exception in log persistence against cache", e);
        }
    }
}

