/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.common;

import java.util.ArrayList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreManager;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public abstract class AbstractStoreManager
implements StoreManager {
    protected final boolean transactional;
    protected final boolean batchLoading;
    protected final Configuration storageConfig;
    protected final boolean assignTimestamp;

    public AbstractStoreManager(Configuration storageConfig) {
        this.batchLoading = storageConfig.get(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]);
        boolean transactional = storageConfig.get(GraphDatabaseConfiguration.STORAGE_TRANSACTIONAL, new String[0]);
        if (this.batchLoading) {
            transactional = false;
        }
        this.assignTimestamp = storageConfig.get(GraphDatabaseConfiguration.ASSIGN_TIMESTAMP, new String[0]);
        this.transactional = transactional;
        this.storageConfig = storageConfig;
    }

    public Configuration getStorageConfig() {
        return this.storageConfig;
    }

    public EntryMetaData[] getMetaDataSchema(String storeName) {
        ArrayList<EntryMetaData> schemaBuilder = new ArrayList<EntryMetaData>(3);
        StoreFeatures features = this.getFeatures();
        if (features.hasTimestamps() && this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, storeName).booleanValue()) {
            schemaBuilder.add(EntryMetaData.TIMESTAMP);
        }
        if (features.hasCellTTL() && this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_TTL, storeName).booleanValue()) {
            schemaBuilder.add(EntryMetaData.TTL);
        }
        if (features.hasVisibility() && this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_VISIBILITY, storeName).booleanValue()) {
            schemaBuilder.add(EntryMetaData.VISIBILITY);
        }
        if (schemaBuilder.isEmpty()) {
            return StaticArrayEntry.EMPTY_SCHEMA;
        }
        return schemaBuilder.toArray(new EntryMetaData[schemaBuilder.size()]);
    }

    public boolean isAssignTimestamp() {
        return this.assignTimestamp;
    }
}

