/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public interface StoreMetaData<T> {
    public static final StoreMetaData<Integer> TTL = TTLImpl.INSTANCE;
    public static final Container EMPTY = new Container(false);

    public Class<? extends T> getDataType();

    public static enum TTLImpl implements StoreMetaData<Integer>
    {
        INSTANCE;


        @Override
        public Class<? extends Integer> getDataType() {
            return Integer.class;
        }
    }

    public static class Container {
        private final boolean mutable;
        private final Map<StoreMetaData<?>, Object> md = new HashMap();

        public Container() {
            this(true);
        }

        public Container(boolean mutable) {
            this.mutable = mutable;
        }

        public <V, K extends StoreMetaData<V>> void put(K type, V value) {
            Preconditions.checkState((boolean)this.mutable);
            this.md.put(type, value);
        }

        public <V, K extends StoreMetaData<V>> V get(K type) {
            return type.getDataType().cast(this.md.get(type));
        }

        public <K extends StoreMetaData<?>> boolean contains(K type) {
            return this.md.containsKey(type);
        }

        public int size() {
            return this.md.size();
        }

        public boolean isEmpty() {
            return this.md.isEmpty();
        }
    }
}

