/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.stats;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.google.common.base.Preconditions;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetricManager {
    INSTANCE;

    private static final Logger log;
    private final MetricRegistry registry = new MetricRegistry();
    private ConsoleReporter consoleReporter = null;
    private CsvReporter csvReporter = null;
    private JmxReporter jmxReporter = null;
    private Slf4jReporter slf4jReporter = null;
    private GangliaReporter gangliaReporter = null;
    private GraphiteReporter graphiteReporter = null;

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public synchronized void addConsoleReporter(Duration reportInterval) {
        if (null != this.consoleReporter) {
            log.debug("Metrics ConsoleReporter already active; not creating another");
            return;
        }
        this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.getRegistry()).build();
        this.consoleReporter.start(reportInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public synchronized void removeConsoleReporter() {
        if (null != this.consoleReporter) {
            this.consoleReporter.stop();
        }
        this.consoleReporter = null;
    }

    public synchronized void addCsvReporter(Duration reportInterval, String output) {
        File outputDir = new File(output);
        if (null != this.csvReporter) {
            log.debug("Metrics CsvReporter already active; not creating another");
            return;
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            log.warn("Failed to create CSV metrics dir {}", (Object)outputDir);
        }
        this.csvReporter = CsvReporter.forRegistry((MetricRegistry)this.getRegistry()).build(outputDir);
        this.csvReporter.start(reportInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public synchronized void removeCsvReporter() {
        if (null != this.csvReporter) {
            this.csvReporter.stop();
        }
        this.csvReporter = null;
    }

    public synchronized void addJmxReporter(String domain, String agentId) {
        if (null != this.jmxReporter) {
            log.debug("Metrics JmxReporter already active; not creating another");
            return;
        }
        JmxReporter.Builder b = JmxReporter.forRegistry((MetricRegistry)this.getRegistry());
        if (null != domain) {
            b.inDomain(domain);
        }
        if (null != agentId) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
            if (null != servers && 1 == servers.size()) {
                b.registerWith((MBeanServer)servers.get(0));
            } else {
                log.error("Metrics Slf4jReporter agentId {} does not resolve to a single MBeanServer", (Object)agentId);
            }
        }
        this.jmxReporter = b.build();
        this.jmxReporter.start();
    }

    public synchronized void removeJmxReporter() {
        if (null != this.jmxReporter) {
            this.jmxReporter.stop();
        }
        this.jmxReporter = null;
    }

    public synchronized void addSlf4jReporter(Duration reportInterval, String loggerName) {
        if (null != this.slf4jReporter) {
            log.debug("Metrics Slf4jReporter already active; not creating another");
            return;
        }
        Slf4jReporter.Builder b = Slf4jReporter.forRegistry((MetricRegistry)this.getRegistry());
        if (null != loggerName) {
            Logger l = LoggerFactory.getLogger((String)loggerName);
            if (null != l) {
                b.outputTo(l);
            } else {
                log.error("Logger with name {} could not be obtained", (Object)loggerName);
            }
        }
        this.slf4jReporter = b.build();
        this.slf4jReporter.start(reportInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public synchronized void removeSlf4jReporter() {
        if (null != this.slf4jReporter) {
            this.slf4jReporter.stop();
        }
        this.slf4jReporter = null;
    }

    public synchronized void addGangliaReporter(String groupOrHost, int port, GMetric.UDPAddressingMode addressingMode, int ttl, Boolean protocol31, UUID hostUUID, String spoof, Duration reportInterval) throws IOException {
        Preconditions.checkNotNull((Object)groupOrHost);
        Preconditions.checkNotNull((Object)addressingMode);
        if (null != this.gangliaReporter) {
            log.debug("Metrics GangliaReporter already active; not creating another");
            return;
        }
        if (null == protocol31) {
            protocol31 = true;
        }
        GMetric ganglia = new GMetric(groupOrHost, port, addressingMode, ttl, protocol31.booleanValue(), hostUUID, spoof);
        GangliaReporter.Builder b = GangliaReporter.forRegistry((MetricRegistry)this.getRegistry());
        this.gangliaReporter = b.build(ganglia);
        this.gangliaReporter.start(reportInterval.toMillis(), TimeUnit.MILLISECONDS);
        log.info("Configured Ganglia Metrics reporter host={} interval={} port={} addrmode={} ttl={} proto31={} uuid={} spoof={}", new Object[]{groupOrHost, reportInterval, port, addressingMode, ttl, protocol31, hostUUID, spoof});
    }

    public synchronized void removeGangliaReporter() {
        if (null != this.gangliaReporter) {
            this.gangliaReporter.stop();
        }
        this.gangliaReporter = null;
    }

    public synchronized void addGraphiteReporter(String host, int port, String prefix, Duration reportInterval) {
        Preconditions.checkNotNull((Object)host);
        Graphite graphite = new Graphite(new InetSocketAddress(host, port));
        GraphiteReporter.Builder b = GraphiteReporter.forRegistry((MetricRegistry)this.getRegistry());
        if (null != prefix) {
            b.prefixedWith(prefix);
        }
        b.filter(MetricFilter.ALL);
        this.graphiteReporter = b.build(graphite);
        this.graphiteReporter.start(reportInterval.toMillis(), TimeUnit.MILLISECONDS);
        log.info("Configured Graphite reporter host={} interval={} port={} prefix={}", new Object[]{host, reportInterval, port, prefix});
    }

    public synchronized void removeGraphiteReporter() {
        if (null != this.graphiteReporter) {
            this.graphiteReporter.stop();
        }
        this.graphiteReporter = null;
    }

    public synchronized void removeAllReporters() {
        this.removeConsoleReporter();
        this.removeCsvReporter();
        this.removeJmxReporter();
        this.removeSlf4jReporter();
        this.removeGangliaReporter();
        this.removeGraphiteReporter();
    }

    public Counter getCounter(String name) {
        return this.getRegistry().counter(name);
    }

    public Counter getCounter(String prefix, String ... names) {
        return this.getRegistry().counter(MetricRegistry.name((String)prefix, (String[])names));
    }

    public Timer getTimer(String name) {
        return this.getRegistry().timer(name);
    }

    public Timer getTimer(String prefix, String ... names) {
        return this.getRegistry().timer(MetricRegistry.name((String)prefix, (String[])names));
    }

    public Histogram getHistogram(String name) {
        return this.getRegistry().histogram(name);
    }

    public Histogram getHistogram(String prefix, String ... names) {
        return this.getRegistry().histogram(MetricRegistry.name((String)prefix, (String[])names));
    }

    public boolean remove(String name) {
        return this.getRegistry().remove(name);
    }

    static {
        log = LoggerFactory.getLogger(MetricManager.class);
    }
}

