/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.util.function.MultiComparator;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;

public class MultiDistinctOrderedIterator<E extends Element>
implements Iterator<E> {
    private final Map<Integer, Iterator<E>> iterators = new LinkedHashMap<Integer, Iterator<E>>();
    private final Map<Integer, E> values = new LinkedHashMap<Integer, E>();
    private final TreeMap<E, Integer> currentElements;
    private final Set<E> allElements = new HashSet();
    private final Integer limit;
    private long count = 0L;

    public MultiDistinctOrderedIterator(Integer lowLimit, Integer highLimit, List<Iterator<E>> iterators, List<HasStepFolder.OrderEntry> orders) {
        this.limit = highLimit;
        MultiComparator comparator = null;
        if (orders.isEmpty()) {
            Stream stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(Iterators.concat(iterators.iterator()), 16), false);
            this.iterators.put(0, stream.iterator());
        } else {
            ArrayList comp = new ArrayList();
            orders.forEach(o -> comp.add(new ElementValueComparator(o.key, (Comparator)o.order)));
            comparator = new MultiComparator(comp);
            for (int i = 0; i < iterators.size(); ++i) {
                this.iterators.put(i, iterators.get(i));
            }
        }
        this.currentElements = new TreeMap(comparator);
        for (long i = 0L; i < (long)lowLimit.intValue() && this.hasNext(); ++i) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.limit != null && this.count >= (long)this.limit.intValue()) {
            return false;
        }
        for (int i = 0; i < this.iterators.size(); ++i) {
            if (this.values.containsKey(i) || !this.iterators.get(i).hasNext()) continue;
            Element element = null;
            do {
                if (!this.allElements.contains(element = (Element)this.iterators.get(i).next())) continue;
                element = null;
            } while (element == null && this.iterators.get(i).hasNext());
            if (element == null) continue;
            this.values.put(i, element);
            this.currentElements.put(element, i);
            this.allElements.add(element);
        }
        return !this.values.isEmpty();
    }

    @Override
    public E next() {
        ++this.count;
        return (E)((Element)this.values.remove(this.currentElements.remove(this.currentElements.firstKey())));
    }
}

