/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.query.condition.Condition;

public class Not<E extends JanusGraphElement>
implements Condition<E> {
    private final Condition<E> condition;

    public Not(Condition<E> condition) {
        Preconditions.checkNotNull(condition);
        this.condition = condition;
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.NOT;
    }

    public Condition<E> getChild() {
        return this.condition;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public int numChildren() {
        return 1;
    }

    @Override
    public boolean evaluate(E element) {
        return !this.condition.evaluate(element);
    }

    @Override
    public Iterable<Condition<E>> getChildren() {
        return ImmutableList.of(this.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.condition});
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other) && this.condition.equals(((Not)other).condition);
    }

    @Override
    public String toString() {
        return "!(" + this.condition.toString() + ")";
    }

    public static <E extends JanusGraphElement> Not<E> of(Condition<E> element) {
        return new Not<E>(element);
    }
}

