/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.log.util;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Objects;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.log.Message;

public abstract class AbstractMessage
implements Message {
    private static final int MAX_PAYLOAD_STR_LENGTH = 400;
    private final StaticBuffer content;
    private final Instant timestamp;
    private final String senderId;

    protected AbstractMessage(StaticBuffer content, Instant timestamp, String senderId) {
        Preconditions.checkArgument((content != null && senderId != null ? 1 : 0) != 0);
        this.content = content;
        this.timestamp = timestamp;
        this.senderId = senderId;
    }

    @Override
    public String getSenderId() {
        return this.senderId;
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public StaticBuffer getContent() {
        return this.content;
    }

    public String toString() {
        String payloadString = this.content.toString();
        if (payloadString.length() > 400) {
            payloadString = payloadString.substring(0, 400) + "...";
        }
        return "Message@" + this.timestamp + ":" + this.senderId + "=" + payloadString;
    }

    public int hashCode() {
        return Objects.hash(this.content, this.timestamp, this.senderId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        AbstractMessage msg = (AbstractMessage)other;
        return this.timestamp.equals(msg.timestamp) && this.senderId.equals(msg.senderId) && this.content.equals(msg.content);
    }
}

