/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.configuration.AbstractConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConfiguration
extends AbstractConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BasicConfiguration.class);
    protected static final String FROZEN_KEY = "hidden.frozen";
    private final ReadConfiguration config;
    private final Restriction restriction;
    private Boolean isFrozen;

    public BasicConfiguration(ConfigNamespace root, ReadConfiguration config, Restriction restriction) {
        super(root);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)((Object)restriction));
        this.config = config;
        this.restriction = restriction;
    }

    protected void verifyOption(ConfigOption option) {
        Preconditions.checkNotNull((Object)option);
        super.verifyElement(option);
        if (this.restriction == Restriction.GLOBAL) {
            Preconditions.checkArgument((boolean)option.isGlobal(), (String)"Can only accept global options: %s", (Object[])new Object[]{option});
        } else if (this.restriction == Restriction.LOCAL) {
            Preconditions.checkArgument((boolean)option.isLocal(), (String)"Can only accept local options: %s", (Object[])new Object[]{option});
        }
    }

    @Override
    public boolean has(ConfigOption option, boolean includeRoot, String ... umbrellaElements) {
        this.verifyOption(option);
        return this.config.get(super.getPath((ConfigElement)option, includeRoot, umbrellaElements), option.getDatatype()) != null;
    }

    @Override
    public <O> O get(ConfigOption<O> option, boolean includeRoot, String ... umbrellaElements) {
        this.verifyOption(option);
        O result = this.config.get(super.getPath(option, includeRoot, umbrellaElements), option.getDatatype());
        return option.get(result);
    }

    @Override
    public Set<String> getContainedNamespaces(ConfigNamespace umbrella, String ... umbrellaElements) {
        return super.getContainedNamespaces(this.config, umbrella, umbrellaElements);
    }

    @Override
    public Map<String, Object> getSubset(ConfigNamespace umbrella, String ... umbrellaElements) {
        return super.getSubset(this.config, umbrella, umbrellaElements);
    }

    @Override
    public Configuration restrictTo(String ... umbrellaElements) {
        return BasicConfiguration.restrictTo(this, umbrellaElements);
    }

    public Map<ConfigElement.PathIdentifier, Object> getAll() {
        HashMap result = Maps.newHashMap();
        for (String key : this.config.getKeys("")) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key));
            try {
                ConfigElement.PathIdentifier pid = ConfigElement.parse(this.getRootNamespace(), key);
                Preconditions.checkArgument((pid.element.isOption() && !pid.lastIsUmbrella ? 1 : 0) != 0);
                result.put(pid, this.get((ConfigOption)pid.element, pid.umbrellaElements));
            }
            catch (IllegalArgumentException e) {
                log.debug("Ignored configuration entry for {} since it does not map to an option", (Object)key, (Object)e);
            }
        }
        return result;
    }

    public boolean isFrozen() {
        if (null == this.isFrozen) {
            Boolean frozen = this.config.get(FROZEN_KEY, Boolean.class);
            this.isFrozen = null == frozen ? false : frozen;
        }
        return this.isFrozen;
    }

    protected void setFrozen() {
        this.isFrozen = true;
    }

    public ReadConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() {
        this.config.close();
    }

    public static enum Restriction {
        LOCAL,
        GLOBAL,
        NONE;

    }
}

