/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class NormalizedFileNames {
    private static final BitSet LEGAL_CHARS = new BitSet();
    private final Map<String, String> mapping = new HashMap<String, String>();
    private final Set<String> usedNames = new HashSet<String>();

    static {
        char[] cArray = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWYXZ0123456789$-._".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            LEGAL_CHARS.set(c);
            ++n2;
        }
    }

    NormalizedFileNames() {
    }

    public String getFileName(String id) {
        String name = this.mapping.get(id);
        if (name != null) {
            return name;
        }
        name = this.replaceIllegalChars(id);
        name = this.ensureUniqueness(name);
        this.mapping.put(id, name);
        return name;
    }

    private String replaceIllegalChars(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        boolean modified = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (LEGAL_CHARS.get(c)) {
                sb.append(c);
            } else {
                sb.append('_');
                modified = true;
            }
            ++i;
        }
        return modified ? sb.toString() : s;
    }

    private String ensureUniqueness(String s) {
        String unique = s;
        String lower = unique.toLowerCase();
        int idx = 1;
        while (this.usedNames.contains(lower)) {
            unique = String.valueOf(s) + '~' + idx++;
            lower = unique.toLowerCase();
        }
        this.usedNames.add(lower);
        return unique;
    }
}

