/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import java.util.List;
import org.jacoco.asm.tree.AbstractInsnNode;
import org.jacoco.asm.tree.JumpInsnNode;
import org.jacoco.asm.tree.LabelNode;
import org.jacoco.asm.tree.LookupSwitchInsnNode;
import org.jacoco.asm.tree.MethodNode;
import org.jacoco.asm.tree.TableSwitchInsnNode;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;

public final class KotlinWhenFilter
implements IFilter {
    private static final String EXCEPTION = "kotlin/NoWhenBranchMatchedException";

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            matcher.match(i, output);
        }
    }

    private static LabelNode getDefaultLabel(AbstractInsnNode i) {
        switch (i.getOpcode()) {
            case 171: {
                return ((LookupSwitchInsnNode)i).dflt;
            }
            case 170: {
                return ((TableSwitchInsnNode)i).dflt;
            }
        }
        return null;
    }

    private static void ignoreDefaultBranch(AbstractInsnNode switchNode, IFilterOutput output) {
        List<LabelNode> labels = switchNode.getOpcode() == 171 ? ((LookupSwitchInsnNode)switchNode).labels : ((TableSwitchInsnNode)switchNode).labels;
        HashSet<AbstractInsnNode> newTargets = new HashSet<AbstractInsnNode>();
        for (LabelNode label : labels) {
            newTargets.add(AbstractMatcher.skipNonOpcodes(label));
        }
        output.replaceBranches(switchNode, newTargets);
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        void match(AbstractInsnNode start, IFilterOutput output) {
            if (start.getType() != 8) {
                return;
            }
            this.cursor = start;
            this.nextIsType(187, KotlinWhenFilter.EXCEPTION);
            this.nextIs(89);
            this.nextIsInvoke(183, KotlinWhenFilter.EXCEPTION, "<init>", "()V");
            this.nextIs(191);
            for (AbstractInsnNode i = this.cursor; i != null; i = i.getPrevious()) {
                if (i.getOpcode() == 153 && ((JumpInsnNode)i).label == start) {
                    output.ignore(i, i);
                    output.ignore(start, this.cursor);
                    return;
                }
                if (KotlinWhenFilter.getDefaultLabel(i) != start) continue;
                KotlinWhenFilter.ignoreDefaultBranch(i, output);
                output.ignore(start, this.cursor);
                return;
            }
        }
    }
}

