/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.asm.tree.MethodNode;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;

public final class EnumEmptyConstructorFilter
implements IFilter {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "(Ljava/lang/String;I)V";

    public void filter(String className, String superClassName, MethodNode methodNode, IFilterOutput output) {
        if ("java/lang/Enum".equals(superClassName) && CONSTRUCTOR_NAME.equals(methodNode.name) && CONSTRUCTOR_DESC.equals(methodNode.desc) && new Matcher().match(methodNode, superClassName)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        private boolean match(MethodNode methodNode, String superClassName) {
            this.firstIsALoad0(methodNode);
            this.nextIs(25);
            this.nextIs(21);
            this.nextIsInvokeSuper(superClassName, EnumEmptyConstructorFilter.CONSTRUCTOR_DESC);
            this.nextIs(177);
            return this.cursor != null;
        }
    }
}

