/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.data.ExecFileLoader;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;

public class MergeTask
extends Task {
    private File destfile;
    private final Union files = new Union();

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void addConfigured(ResourceCollection resources) {
        this.files.add(resources);
    }

    public void execute() throws BuildException {
        if (this.destfile == null) {
            throw new BuildException("Destination file must be supplied", this.getLocation());
        }
        ExecFileLoader loader = new ExecFileLoader();
        this.load(loader);
        this.save(loader);
    }

    private void load(ExecFileLoader loader) {
        for (Resource resource : this.files) {
            if (resource.isDirectory()) continue;
            this.log(String.format("Loading execution data file %s", resource));
            InputStream resourceStream = null;
            try {
                resourceStream = resource.getInputStream();
                loader.load(resourceStream);
            }
            catch (IOException e) {
                throw new BuildException(String.format("Unable to read %s", resource), (Throwable)e, this.getLocation());
            }
            finally {
                FileUtils.close((InputStream)resourceStream);
            }
        }
    }

    private void save(ExecFileLoader loader) {
        this.log(String.format("Writing merged execution data to %s", this.destfile.getAbsolutePath()));
        BufferedOutputStream outputStream = null;
        try {
            FileUtils.getFileUtils().createNewFile(this.destfile, true);
            outputStream = new BufferedOutputStream(new FileOutputStream(this.destfile));
            ExecutionDataWriter dataWriter = new ExecutionDataWriter((OutputStream)outputStream);
            loader.getSessionInfoStore().accept((ISessionInfoVisitor)dataWriter);
            loader.getExecutionDataStore().accept((IExecutionDataVisitor)dataWriter);
        }
        catch (IOException e) {
            try {
                throw new BuildException(String.format("Unable to write merged file %s", this.destfile.getAbsolutePath()), (Throwable)e, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(outputStream);
                throw throwable;
            }
        }
        FileUtils.close((OutputStream)outputStream);
    }
}

