/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;

public class MergeTask
extends Task {
    private File destfile;
    private final Union files = new Union();

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void addConfigured(ResourceCollection resources) {
        this.files.add(resources);
    }

    public void execute() throws BuildException {
        if (this.destfile == null) {
            throw new BuildException("Destination file must be supplied", this.getLocation());
        }
        SessionInfoStore infoStore = new SessionInfoStore();
        ExecutionDataStore dataStore = new ExecutionDataStore();
        this.loadSourceFiles(infoStore, dataStore);
        BufferedOutputStream outputStream = null;
        try {
            try {
                FileUtils.getFileUtils().createNewFile(this.destfile, true);
                outputStream = new BufferedOutputStream(new FileOutputStream(this.destfile));
                ExecutionDataWriter dataWriter = new ExecutionDataWriter((OutputStream)outputStream);
                infoStore.accept((ISessionInfoVisitor)dataWriter);
                dataStore.accept((IExecutionDataVisitor)dataWriter);
            }
            catch (IOException e) {
                throw new BuildException(String.format("Unable to write merged file %s", this.destfile.getAbsolutePath()), (Throwable)e, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(outputStream);
            throw throwable;
        }
        FileUtils.close((OutputStream)outputStream);
    }

    private void loadSourceFiles(SessionInfoStore infoStore, ExecutionDataStore dataStore) {
        for (Resource resource : this.files) {
            if (resource.isDirectory()) continue;
            this.log(String.format("Loading execution data file %s", resource));
            InputStream resourceStream = null;
            try {
                try {
                    resourceStream = resource.getInputStream();
                    ExecutionDataReader reader = new ExecutionDataReader(resourceStream);
                    reader.setSessionInfoVisitor((ISessionInfoVisitor)infoStore);
                    reader.setExecutionDataVisitor((IExecutionDataVisitor)dataStore);
                    reader.read();
                }
                catch (IOException e) {
                    throw new BuildException(String.format("Unable to read %s", resource), (Throwable)e, this.getLocation());
                }
            }
            finally {
                FileUtils.close((InputStream)resourceStream);
            }
        }
    }
}

