/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

public class DumpTask
extends Task {
    private static final OutputStream NUL = new OutputStream(){

        public void write(int b) throws IOException {
        }
    };
    private boolean dump = true;
    private boolean reset = false;
    private File destfile = null;
    private String address = AgentOptions.DEFAULT_ADDRESS;
    private int port = 6300;
    private boolean append = true;

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void execute() throws BuildException {
        if (this.port <= 0) {
            throw new BuildException("Invalid port value", this.getLocation());
        }
        if (this.dump && this.destfile == null) {
            throw new BuildException("Destination file is required when dumping execution data", this.getLocation());
        }
        OutputStream output = null;
        try {
            try {
                Socket socket = new Socket(InetAddress.getByName(this.address), this.port);
                this.log(String.format("Connecting to %s", socket.getRemoteSocketAddress()));
                RemoteControlWriter remoteWriter = new RemoteControlWriter(socket.getOutputStream());
                RemoteControlReader remoteReader = new RemoteControlReader(socket.getInputStream());
                output = this.openOutputStream();
                ExecutionDataWriter outputWriter = new ExecutionDataWriter(output);
                remoteReader.setSessionInfoVisitor((ISessionInfoVisitor)outputWriter);
                remoteReader.setExecutionDataVisitor((IExecutionDataVisitor)outputWriter);
                remoteWriter.visitDumpCommand(this.dump, this.reset);
                remoteReader.read();
                socket.close();
            }
            catch (IOException e) {
                throw new BuildException("Unable to dump coverage data", (Throwable)e, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(output);
            throw throwable;
        }
        FileUtils.close((OutputStream)output);
    }

    private OutputStream openOutputStream() throws IOException {
        OutputStream output;
        if (this.dump) {
            this.log(String.format("Dumping execution data to %s", this.destfile.getAbsolutePath()));
            FileUtils.getFileUtils().createNewFile(this.destfile, true);
            output = new FileOutputStream(this.destfile, this.append);
        } else {
            output = NUL;
        }
        return output;
    }
}

