/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_6474ae9.core.runtime;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import org.jacoco.agent.rt.internal_6474ae9.asm.ClassReader;
import org.jacoco.agent.rt.internal_6474ae9.asm.ClassVisitor;
import org.jacoco.agent.rt.internal_6474ae9.asm.ClassWriter;
import org.jacoco.agent.rt.internal_6474ae9.asm.MethodVisitor;
import org.jacoco.agent.rt.internal_6474ae9.core.runtime.AbstractRuntime;
import org.jacoco.agent.rt.internal_6474ae9.core.runtime.IRuntime;
import org.jacoco.agent.rt.internal_6474ae9.core.runtime.RuntimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiedSystemClassRuntime
extends AbstractRuntime {
    private static final String ACCESS_FIELD_TYPE = "Ljava/lang/Object;";
    private final Class<?> systemClass;
    private final String systemClassName;
    private final String accessFieldName;

    public ModifiedSystemClassRuntime(Class<?> systemClass, String accessFieldName) {
        this.systemClass = systemClass;
        this.systemClassName = systemClass.getName().replace('.', '/');
        this.accessFieldName = accessFieldName;
    }

    @Override
    public void startup(RuntimeData data) throws Exception {
        super.startup(data);
        Field field = this.systemClass.getField(this.accessFieldName);
        field.set(null, data);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public int generateDataAccessor(long classid, String classname, int probecount, MethodVisitor mv) {
        mv.visitFieldInsn(178, this.systemClassName, this.accessFieldName, ACCESS_FIELD_TYPE);
        RuntimeData.generateAccessCall(classid, classname, probecount, mv);
        return 6;
    }

    public static IRuntime createFor(Instrumentation inst, String className) throws ClassNotFoundException {
        return ModifiedSystemClassRuntime.createFor(inst, className, "$jacocoAccess");
    }

    public static IRuntime createFor(Instrumentation inst, final String className, final String accessFieldName) throws ClassNotFoundException {
        ClassFileTransformer transformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String name, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] source) throws IllegalClassFormatException {
                if (name.equals(className)) {
                    return ModifiedSystemClassRuntime.instrument(source, accessFieldName);
                }
                return null;
            }
        };
        inst.addTransformer(transformer);
        Class<?> clazz = Class.forName(className.replace('/', '.'));
        inst.removeTransformer(transformer);
        try {
            clazz.getField(accessFieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(String.format("Class %s could not be instrumented.", className), e);
        }
        return new ModifiedSystemClassRuntime(clazz, accessFieldName);
    }

    public static byte[] instrument(byte[] source, final String accessFieldName) {
        ClassReader reader = new ClassReader(source);
        ClassWriter writer = new ClassWriter(reader, 0);
        reader.accept(new ClassVisitor(262144, writer){

            public void visitEnd() {
                ModifiedSystemClassRuntime.createDataField(this.cv, accessFieldName);
                super.visitEnd();
            }
        }, 8);
        return writer.toByteArray();
    }

    private static void createDataField(ClassVisitor visitor, String dataField) {
        visitor.visitField(4233, dataField, ACCESS_FIELD_TYPE, null, null);
    }
}

