/*
 * Decompiled with CFR 0.152.
 */
package org.jackstaff.grpc.configuration;

import org.jackstaff.grpc.Client;
import org.jackstaff.grpc.Server;
import org.jackstaff.grpc.configuration.Configuration;
import org.jackstaff.grpc.configuration.SpringConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={Configuration.class})
public class AutoConfiguration {
    private final SpringConfiguration springConfiguration;

    public AutoConfiguration(ApplicationContext appContext, Configuration configuration) {
        this.springConfiguration = new SpringConfiguration(appContext, configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={Server.class})
    public Server packetServer() throws Exception {
        return this.springConfiguration.newServer();
    }

    @Bean
    @ConditionalOnMissingBean(value={Client.class})
    public Client packetClient() throws Exception {
        return this.springConfiguration.newClient();
    }
}

