/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util.lic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.itsnat.impl.core.util.IOUtil;

public class LicenseChanger {
    public static final String SOURCE_PATH = "C:\\trabajo\\empresa\\opensource\\itsnat_dev\\src\\java\\org\\itsnat";
    public static final String FILE_TEST = "C:\\trabajo\\empresa\\opensource\\itsnat_dev\\src\\java\\org\\itsnat\\impl\\core\\util\\WeakSetImpl.java";
    public static final boolean SIMULATION = true;

    public static void main(String[] args) throws Exception {
        LicenseChanger.processFile(new File(FILE_TEST));
    }

    public static void processTreeFile(File file) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                LicenseChanger.processTreeFile(files[i]);
            }
        } else {
            LicenseChanger.processFile(file);
        }
    }

    public static void processFile(File file) throws Exception {
        int res;
        System.out.println(file.getAbsolutePath());
        StringBuilder str = new StringBuilder();
        FileInputStream input = new FileInputStream(file);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        while ((res = input.read(buffer)) != -1) {
            str.append(new String(buffer, 0, res));
            output.write(buffer, 0, res);
        }
        input.close();
        output.close();
        int[] posEndLicense = new int[]{608, 597, 580};
        String content = str.toString();
        int type = LicenseChanger.getLicenseFormat(content, posEndLicense);
        if (type == -1) {
            return;
        }
        System.out.println("Licensed: TRUE " + type);
        byte[] fileData = output.toByteArray();
        int offset = posEndLicense[type] + 2;
        byte[] fileDataWithoutLicense = new byte[fileData.length - offset];
        System.arraycopy(fileData, offset, fileDataWithoutLicense, 0, fileDataWithoutLicense.length);
        byte[] newLicenseBytes = LicenseChanger.readNewLicense();
        LicenseChanger.writeToFile(file.getAbsolutePath(), newLicenseBytes, fileDataWithoutLicense);
    }

    public static void writeToFile(String filePath, byte[] newLicenseBytes, byte[] fileDataWithoutLicense) throws Exception {
        int i;
        for (i = 0; i < newLicenseBytes.length; ++i) {
            System.out.print((char)newLicenseBytes[i]);
        }
        for (i = 0; i < fileDataWithoutLicense.length; ++i) {
            System.out.print((char)fileDataWithoutLicense[i]);
        }
    }

    public static int getLicenseFormat(String content, int[] posEndLicense) {
        int type;
        int pos = content.indexOf("ItsNat Java Web Application Framework");
        if (pos == -1) {
            return -1;
        }
        if (pos > 6) {
            return -1;
        }
        pos = content.indexOf("*/");
        switch (pos) {
            case 608: {
                type = 0;
                break;
            }
            case 597: {
                type = 1;
                break;
            }
            case 580: {
                type = 2;
                break;
            }
            default: {
                return -1;
            }
        }
        pos = content.indexOf("GNU Affero General Public License");
        if (pos < 0) {
            return -1;
        }
        if (pos > posEndLicense[type]) {
            return -1;
        }
        return type;
    }

    public static byte[] readNewLicense() {
        InputStream input = LicenseChanger.class.getResourceAsStream("LICENSE.txt");
        return LicenseChanger.readFile(input);
    }

    public static byte[] readFile(InputStream input) {
        return IOUtil.readInputStream(input);
    }
}

