/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.itsnat.core.ItsNatException;

public class WeakSetImpl<K>
implements Set<K>,
Serializable {
    protected transient WeakHashMap<K, Object> map;

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<K, Object> mapTmp = null;
        if (this.map != null) {
            mapTmp = new HashMap<K, Object>(this.map);
        }
        out.writeObject(mapTmp);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Map mapTmp = (Map)in.readObject();
        if (mapTmp != null) {
            this.getWeakHashMap().putAll(mapTmp);
        }
        in.defaultReadObject();
    }

    public WeakHashMap<K, Object> getWeakHashMap() {
        if (this.map == null) {
            this.map = new WeakHashMap();
        }
        return this.map;
    }

    @Override
    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    @Override
    public void clear() {
        if (this.map == null) {
            return;
        }
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return true;
        }
        return this.map.isEmpty();
    }

    @Override
    public boolean add(K obj) {
        Object res = this.getWeakHashMap().put(obj, null);
        if (res != null) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return true;
    }

    @Override
    public boolean contains(Object obj) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(obj);
    }

    @Override
    public boolean remove(Object obj) {
        if (this.map == null) {
            return false;
        }
        Object res = this.map.remove(obj);
        return res != obj;
    }

    @Override
    public boolean addAll(Collection<? extends K> col) {
        throw new ItsNatException("INTERNAL ERROR");
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        throw new ItsNatException("INTERNAL ERROR");
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        throw new ItsNatException("INTERNAL ERROR");
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        throw new ItsNatException("INTERNAL ERROR");
    }

    @Override
    public Iterator<K> iterator() {
        return this.getWeakHashMap().keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getWeakHashMap().keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getWeakHashMap().keySet().toArray(a);
    }
}

