/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.itsnat.core.ItsNatException;

public class WeakMapExpungeableImpl
implements Serializable {
    protected transient WeakHashMap<Object, KeyValuePair> weakMap = new WeakHashMap();
    protected transient HashMap<WeakReference<Object>, KeyValuePair> weakRefMap = new HashMap();
    protected transient ReferenceQueue<Object> queue = new ReferenceQueue();
    protected ExpungeListener listener;

    public WeakMapExpungeableImpl(ExpungeListener listener) {
        this.listener = listener;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap mapTmp = new HashMap();
        for (Map.Entry<WeakReference<Object>, KeyValuePair> entry : this.weakRefMap.entrySet()) {
            WeakReference<Object> weakRef = entry.getKey();
            KeyValuePair pair = entry.getValue();
            Object key = weakRef.get();
            Object value = pair.getValue();
            mapTmp.put(key, value);
        }
        out.writeObject(mapTmp);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.queue = new ReferenceQueue();
        this.weakMap = new WeakHashMap();
        this.weakRefMap = new HashMap();
        Map mapTmp = (Map)in.readObject();
        for (Map.Entry entry : mapTmp.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            WeakReference<Object> weakRef = new WeakReference<Object>(key, this.queue);
            KeyValuePair pair = new KeyValuePair(weakRef, value);
            this.weakMap.put(key, pair);
            this.weakRefMap.put(weakRef, pair);
        }
        in.defaultReadObject();
    }

    public Object remove(Object key) {
        this.cleanUnused();
        KeyValuePair pair = this.weakMap.remove(key);
        if (pair == null) {
            return null;
        }
        WeakReference<Object> weakRef = pair.getKey();
        this.weakRefMap.remove(weakRef);
        return pair.getValue();
    }

    public Object get(Object key) {
        this.cleanUnused();
        KeyValuePair pair = this.weakMap.get(key);
        if (pair == null) {
            return null;
        }
        return pair.getValue();
    }

    public Object put(Object key, Object value) {
        this.cleanUnused();
        WeakReference<Object> weakKeyRef = new WeakReference<Object>(key, this.queue);
        KeyValuePair pair = new KeyValuePair(weakKeyRef, value);
        KeyValuePair oldPair = this.weakMap.put(key, pair);
        this.weakRefMap.put(weakKeyRef, pair);
        if (oldPair == null) {
            return null;
        }
        return oldPair.getValue();
    }

    public void cleanUnused() {
        Reference<Object> weakRef = this.queue.poll();
        while (weakRef != null) {
            KeyValuePair pair = this.weakRefMap.remove(weakRef);
            if (pair != null && this.listener != null) {
                this.listener.processExpunged(pair.getValue());
            }
            weakRef = this.queue.poll();
        }
    }

    public boolean isEmpty() {
        this.cleanUnused();
        boolean res = this.weakMap.isEmpty();
        if (res != this.weakRefMap.isEmpty()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        return res;
    }

    public Set<Map.Entry<Object, KeyValuePair>> entrySet() {
        return this.weakMap.entrySet();
    }

    public static interface ExpungeListener {
        public void processExpunged(Object var1);
    }

    public static class KeyValuePair
    implements Serializable {
        protected transient WeakReference<Object> key;
        protected Object value;

        public KeyValuePair(WeakReference<Object> key, Object value) {
            this.key = key;
            this.value = value;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            Object obj = null;
            if (this.key != null) {
                obj = this.key.get();
            }
            out.writeObject(obj);
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object obj = in.readObject();
            if (obj != null) {
                this.key = new WeakReference<Object>(obj);
            }
            in.defaultReadObject();
        }

        public WeakReference<Object> getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

