/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.util.UniqueIdGenerator;

public class UniqueIdGenMessageDigest
implements UniqueIdGenerator {
    protected MessageDigest md;

    public UniqueIdGenMessageDigest() {
        try {
            this.md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ItsNatException(ex);
        }
    }

    public String generateId(String idRef, String prefix) {
        MessageDigest newMd;
        try {
            newMd = (MessageDigest)this.md.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new ItsNatException(ex);
        }
        byte[] idBytes = newMd.digest(idRef.getBytes());
        StringBuilder code = new StringBuilder();
        code.append(prefix + "_");
        for (int i = 0; i < idBytes.length; ++i) {
            int n = idBytes[i];
            code.append(Integer.toHexString(n &= 0xFF));
        }
        return code.toString();
    }
}

