/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util;

import java.io.Serializable;
import org.itsnat.impl.core.util.UniqueId;
import org.itsnat.impl.core.util.UniqueIdGenerator;

public class UniqueIdGenIntList
implements UniqueIdGenerator,
Serializable {
    protected final boolean sync;
    protected long[] counters;

    public UniqueIdGenIntList(boolean sync) {
        this.sync = sync;
        this.counters = new long[1];
    }

    public UniqueId generateUniqueId(String prefix) {
        return new UniqueId(this.generateId(prefix), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateId(String prefix) {
        long[] id;
        if (this.sync) {
            UniqueIdGenIntList uniqueIdGenIntList = this;
            synchronized (uniqueIdGenIntList) {
                id = this.generateUniqueIdInternal(true);
            }
        } else {
            id = this.generateUniqueIdInternal(false);
        }
        StringBuilder code = new StringBuilder();
        code.append(prefix + "_");
        for (int i = 0; i < id.length; ++i) {
            long curr = id[i];
            if (i > 0) {
                code.append("_");
            }
            code.append(Long.toString(curr));
        }
        return code.toString();
    }

    protected long[] generateUniqueIdInternal(boolean clone) {
        long last = this.counters[this.counters.length - 1];
        if (last == Long.MAX_VALUE) {
            long[] oldCounters = this.counters;
            this.counters = new long[oldCounters.length + 1];
            System.arraycopy(oldCounters, 0, this.counters, 0, oldCounters.length);
            last = this.counters[this.counters.length - 1];
        }
        this.counters[this.counters.length - 1] = ++last;
        if (clone) {
            long[] id = new long[this.counters.length];
            System.arraycopy(this.counters, 0, id, 0, this.counters.length);
            return id;
        }
        return this.counters;
    }
}

