/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.itsnat.impl.core.util.UniqueIdGenerator;

public class MapUniqueId<T extends HasUniqueId>
implements Serializable {
    protected Map<String, T> map = new HashMap<String, T>();
    protected UniqueIdGenerator generator;

    public MapUniqueId(UniqueIdGenerator generator) {
        this.generator = generator;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(T obj) {
        this.check(obj);
        UniqueId idObj = obj.getUniqueId();
        String id = idObj.getId();
        return this.map.containsKey(id);
    }

    public void putAll(MapUniqueId<T> otherMap) {
        this.check(otherMap.generator);
        this.map.putAll(otherMap.map);
    }

    public Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    public Collection<T> values() {
        return this.map.values();
    }

    public T get(String id) {
        return (T)((HasUniqueId)this.map.get(id));
    }

    public T put(T obj) {
        this.check(obj);
        UniqueId idObj = obj.getUniqueId();
        String id = idObj.getId();
        return (T)((HasUniqueId)this.map.put(id, obj));
    }

    public T removeById(String id) {
        return (T)((HasUniqueId)this.map.remove(id));
    }

    public T remove(T obj) {
        this.check(obj);
        UniqueId idObj = obj.getUniqueId();
        String id = idObj.getId();
        return (T)((HasUniqueId)this.map.remove(id));
    }

    public T[] toArray(T[] array) {
        if (array.length != this.size()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
        int i = 0;
        for (Map.Entry<String, T> entry : this.map.entrySet()) {
            HasUniqueId value = (HasUniqueId)entry.getValue();
            array[i] = value;
            ++i;
        }
        return array;
    }

    public void check(T idObj) {
        MapUniqueId.check(this.generator, idObj);
    }

    public void check(UniqueIdGenerator generator) {
        if (this.generator != generator) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    public static void check(UniqueIdGenerator generator, HasUniqueId obj) {
        if (generator != obj.getUniqueId().getUniqueIdGenerator()) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }
}

