/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class MapListImpl<K, V>
implements Serializable {
    public Map<K, LinkedList<V>> map = new HashMap<K, LinkedList<V>>();

    public Map<K, LinkedList<V>> getMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int add(K key, V value) {
        LinkedList<Object> list = this.map.get(key);
        if (list == null) {
            list = new LinkedList();
            this.map.put(key, list);
        }
        list.add(value);
        return list.size() - 1;
    }

    public LinkedList<V> get(K key) {
        return this.map.get(key);
    }

    public LinkedList<V> remove(K key) {
        return this.map.remove(key);
    }

    public LinkedList<V> getAllValuesCopy() {
        if (this.isEmpty()) {
            return null;
        }
        LinkedList<V> res = new LinkedList<V>();
        for (Map.Entry<K, LinkedList<V>> entry : this.map.entrySet()) {
            LinkedList<V> list = entry.getValue();
            res.addAll(list);
        }
        return res;
    }

    public boolean contains(K key, V value) {
        LinkedList<V> list = this.map.get(key);
        if (list == null) {
            return false;
        }
        for (Object currValue : list) {
            if (currValue != value && (value == null || !value.equals(currValue))) continue;
            return true;
        }
        return false;
    }

    public V remove(K key, V value) {
        LinkedList<V> list = this.map.get(key);
        if (list == null) {
            return null;
        }
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object currValue = it.next();
            if (currValue != value && (value == null || !value.equals(currValue))) continue;
            it.remove();
            if (list.isEmpty()) {
                this.map.remove(key);
            }
            return (V)currValue;
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }
}

