/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template.web.html;

import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.MarkupContainerImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.template.MarkupTemplateVersionDelegateImpl;
import org.itsnat.impl.core.template.web.ItsNatWebOnlyDocFragmentTemplateVersionImpl;
import org.itsnat.impl.core.template.web.html.HTMLTemplateVersionDelegateImpl;
import org.itsnat.impl.core.template.web.html.ItsNatHTMLDocFragmentTemplateImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLHeadElement;
import org.xml.sax.InputSource;

public class ItsNatHTMLDocFragmentTemplateVersionImpl
extends ItsNatWebOnlyDocFragmentTemplateVersionImpl {
    protected DocumentFragment templateDocFragmentHead;

    public ItsNatHTMLDocFragmentTemplateVersionImpl(ItsNatHTMLDocFragmentTemplateImpl docTemplate, InputSource source, long timeStamp, ItsNatServletRequest request, ItsNatServletResponse response) {
        super(docTemplate, source, timeStamp, request, response);
        HTMLDocument templateHtmlDoc = (HTMLDocument)this.getDocument();
        HTMLHeadElement head = DOMUtilHTML.getHTMLHead(templateHtmlDoc);
        this.templateDocFragmentHead = this.extractChildrenToDocFragment(head);
        this.templateDoc = null;
    }

    @Override
    public Element getContainerElement() {
        HTMLDocument templateHtmlDoc = (HTMLDocument)this.getDocument();
        return (HTMLBodyElement)templateHtmlDoc.getBody();
    }

    public HTMLTemplateVersionDelegateImpl getHTMLTemplateVersionDelegate() {
        return (HTMLTemplateVersionDelegateImpl)this.templateDelegate;
    }

    @Override
    protected boolean isElementValidForCaching(Element elem) {
        if (!super.isElementValidForCaching(elem)) {
            return false;
        }
        if (elem instanceof HTMLHeadElement || elem instanceof HTMLBodyElement) {
            return false;
        }
        return !this.getHTMLTemplateVersionDelegate().isSVGWebMetaDeclaration(elem);
    }

    public DocumentFragment loadDocumentFragmentHead(MarkupContainerImpl target) {
        return this.loadDocumentFragment(this.templateDocFragmentHead, target);
    }

    public DocumentFragment loadDocumentFragmentBody(MarkupContainerImpl target) {
        return this.loadDocumentFragment(target);
    }

    @Override
    public DocumentFragment loadDocumentFragmentByIncludeTag(MarkupContainerImpl target, Element includeElem) {
        if (DOMUtilHTML.isChildOfHTMLHead(includeElem)) {
            return this.loadDocumentFragmentHead(target);
        }
        return this.loadDocumentFragment(target);
    }

    @Override
    protected MarkupTemplateVersionDelegateImpl createMarkupTemplateVersionDelegate() {
        return new HTMLTemplateVersionDelegateImpl(this);
    }

    @Override
    public void cleanDOMPattern() {
        super.cleanDOMPattern();
        this.templateDocFragmentHead = null;
    }
}

