/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template.web.html;

import java.util.LinkedList;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.itsnat.impl.core.template.web.StfulWebTemplateVersionDelegateImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLMetaElement;
import org.w3c.dom.html.HTMLStyleElement;

public class HTMLTemplateVersionDelegateImpl
extends StfulWebTemplateVersionDelegateImpl {
    public HTMLTemplateVersionDelegateImpl(MarkupTemplateVersionImpl parent) {
        super(parent);
    }

    @Override
    public void normalizeDocument(Document doc) {
        super.normalizeDocument(doc);
        HTMLTemplateVersionDelegateImpl.normalizeHTMLDocument((HTMLDocument)doc);
    }

    public static void normalizeHTMLDocument(HTMLDocument doc) {
        LinkedList<Node> styles = DOMUtilInternal.getChildElementListWithTagNameNS(doc, "http://www.w3.org/1999/xhtml", "style", true);
        if (styles != null) {
            HTMLHeadElement head = DOMUtilHTML.getHTMLHead(doc);
            for (HTMLStyleElement hTMLStyleElement : styles) {
                if (hTMLStyleElement.getParentNode() == head) continue;
                head.appendChild(hTMLStyleElement);
            }
        }
    }

    public boolean isSVGWebMetaDeclaration(Element elem) {
        return HTMLTemplateVersionDelegateImpl.isSVGWebMetaDeclarationStatic(elem);
    }

    public static boolean isSVGWebMetaDeclarationStatic(Element elem) {
        return elem instanceof HTMLMetaElement && ((HTMLMetaElement)elem).getName().equals("svg.render.forceflash");
    }
}

