/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template.web;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.impl.comp.mgr.web.ItsNatStfulWebDocComponentManagerImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.template.MarkupTemplateVersionImpl;
import org.itsnat.impl.core.template.StfulTemplateVersionDelegateImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableElement;

public abstract class StfulWebTemplateVersionDelegateImpl
extends StfulTemplateVersionDelegateImpl {
    public static final Set<String> HTML_ELEMS_NOT_USE_CHILD_TEXT = new HashSet<String>();
    public static final Set<String> HTML_ELEMS_NOT_VALID_CHILD_COMMENT = new HashSet<String>();

    public StfulWebTemplateVersionDelegateImpl(MarkupTemplateVersionImpl parent) {
        super(parent);
    }

    public static void normalizeHTMLElements(Document doc) {
        LinkedList<Node> htmlTables = DOMUtilInternal.getChildElementListWithTagNameNS(doc, "http://www.w3.org/1999/xhtml", "table", true);
        if (htmlTables != null) {
            for (HTMLTableElement hTMLTableElement : htmlTables) {
                boolean hasTBody = ItsNatTreeWalker.getFirstChildElementWithTagNameNS(hTMLTableElement, "http://www.w3.org/1999/xhtml", "tbody") != null;
                if (hasTBody) continue;
                HTMLElement tbody = (HTMLElement)doc.createElementNS("http://www.w3.org/1999/xhtml", "tbody");
                Node child = ItsNatTreeWalker.getFirstChildElementWithTagNameNS(hTMLTableElement, "http://www.w3.org/1999/xhtml", "tr");
                while (child != null) {
                    Node next = child.getNextSibling();
                    tbody.appendChild(child);
                    child = next;
                }
                hTMLTableElement.appendChild(tbody);
            }
        }
        for (String string : HTML_ELEMS_NOT_USE_CHILD_TEXT) {
            StfulWebTemplateVersionDelegateImpl.removeUnusefulHTMLChildTextNodes(string, doc);
        }
        for (String string : HTML_ELEMS_NOT_VALID_CHILD_COMMENT) {
            StfulWebTemplateVersionDelegateImpl.removeUnusefulHTMLChildComments(string, doc);
        }
    }

    public static void removeUnusefulHTMLChildTextNodes(String localName, Document doc) {
        LinkedList<Node> elements = DOMUtilInternal.getChildElementListWithTagNameNS(doc, "http://www.w3.org/1999/xhtml", localName, true);
        if (elements != null) {
            for (Element element : elements) {
                DOMUtilInternal.removeAllUnusefulChildTextNodes(element);
            }
        }
    }

    public static void removeUnusefulHTMLChildComments(String localName, Document doc) {
        LinkedList<Node> elements = DOMUtilInternal.getChildElementListWithTagNameNS(doc, "http://www.w3.org/1999/xhtml", localName, true);
        if (elements != null) {
            for (Element element : elements) {
                DOMUtilInternal.removeAllDirectChildComments(element);
            }
        }
    }

    @Override
    public void normalizeDocument(Document doc) {
        super.normalizeDocument(doc);
        StfulWebTemplateVersionDelegateImpl.normalizeHTMLElements(doc);
    }

    @Override
    public boolean declaredAsComponent(Element elem) {
        boolean decAsComp = super.declaredAsComponent(elem);
        if (decAsComp) {
            return true;
        }
        return ItsNatStfulWebDocComponentManagerImpl.declaredAsHTMLComponent(elem);
    }

    static {
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("dl");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("frameset");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("head");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("html");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("map");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("menu");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("ol");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("optgroup");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("select");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("table");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("tbody");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("tfoot");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("thead");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("tr");
        HTML_ELEMS_NOT_USE_CHILD_TEXT.add("ul");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("frameset");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("html");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("dl");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("ol");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("optgroup");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("select");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("table");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("td");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("tbody");
        HTML_ELEMS_NOT_VALID_CHILD_COMMENT.add("ul");
    }
}

