/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template.droid;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.template.droid.ScriptCode;
import org.itsnat.impl.core.util.IOUtil;

public class ScriptLocalFile
extends ScriptCode {
    protected File file;
    protected long timeStamp;

    public ScriptLocalFile(String src, ServletContext servContext) {
        String basePath = servContext.getRealPath("/");
        String filePath = basePath + src;
        File fileBasePath = new File(basePath);
        File file = new File(filePath);
        boolean unexpected = false;
        try {
            unexpected = !file.getCanonicalPath().startsWith(fileBasePath.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
        if (unexpected) {
            throw new ItsNatException("Unexpected security break attempt");
        }
        this.file = file;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        long timeStamp = this.file.lastModified();
        if (this.timeStamp == timeStamp) {
            return;
        }
        ScriptLocalFile scriptLocalFile = this;
        synchronized (scriptLocalFile) {
            this.timeStamp = timeStamp;
            this.code = IOUtil.readTextFile(this.file, "UTF-8");
        }
    }

    @Override
    public String getCode() {
        this.reload();
        return super.getCode();
    }
}

