/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.core.template.droid;

import java.util.LinkedList;
import java.util.Map;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.doc.droid.ItsNatStfulDroidDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.domutil.NodeConstraints;
import org.itsnat.impl.core.markup.parse.XercesDOMParserWrapperImpl;
import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateImpl;
import org.itsnat.impl.core.template.ItsNatStfulDocumentTemplateVersionImpl;
import org.itsnat.impl.core.template.MarkupTemplateVersionDelegateImpl;
import org.itsnat.impl.core.template.droid.StfulDroidTemplateVersionDelegateImpl;
import org.itsnat.impl.core.util.MapEntryImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ItsNatStfulDroidDocumentTemplateVersionImpl
extends ItsNatStfulDocumentTemplateVersionImpl {
    protected String androidNamespacePrefix;
    protected LinkedList<Map.Entry<String, String>> namespacesDeclared = new LinkedList();

    public ItsNatStfulDroidDocumentTemplateVersionImpl(ItsNatStfulDocumentTemplateImpl docTemplate, InputSource source, long timeStamp, ItsNatServletRequest request, ItsNatServletResponse response) {
        super(docTemplate, source, timeStamp, request, response);
        this.readNamespaces();
    }

    public String getAndroidNamespacePrefix() {
        return this.androidNamespacePrefix;
    }

    protected void readNamespaces() {
        Element rootElem = this.templateDoc.getDocumentElement();
        if (rootElem.hasAttributes()) {
            NamedNodeMap attribs = rootElem.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Attr attr = (Attr)attribs.item(i);
                String name = attr.getName();
                if (!name.startsWith("xmlns:")) continue;
                int pos = name.indexOf(58);
                String prefix = name.substring(pos + 1);
                String namespaceURI = attr.getValue();
                this.namespacesDeclared.add(new MapEntryImpl<String, String>(prefix, namespaceURI));
                if (!"http://schemas.android.com/apk/res/android".equals(namespaceURI)) continue;
                this.androidNamespacePrefix = prefix;
            }
        }
        if (this.androidNamespacePrefix == null) {
            this.androidNamespacePrefix = "android";
        }
    }

    @Override
    public String wrapBodyAsDocument(String source) {
        StringBuilder code = new StringBuilder();
        code.append("<root");
        for (Map.Entry entry : this.namespacesDeclared) {
            code.append(" xmlns:" + (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"");
        }
        code.append(">");
        code.append(source);
        code.append("</root>");
        return code.toString();
    }

    @Override
    public Element getBodyParentElement(Document doc) {
        return doc.getDocumentElement();
    }

    @Override
    protected ItsNatDocumentImpl createItsNatDocument(Document doc, Browser browser, String requestURL, ItsNatSessionImpl session, boolean stateless) {
        return new ItsNatStfulDroidDocumentImpl(doc, this, browser, requestURL, session, stateless);
    }

    @Override
    protected MarkupTemplateVersionDelegateImpl createMarkupTemplateVersionDelegate() {
        return new StfulDroidTemplateVersionDelegateImpl(this);
    }

    @Override
    public Document parseDocumentOrFragment(InputSource input, XercesDOMParserWrapperImpl parser, boolean isFragment) {
        NodeConstraints rule;
        Document doc = super.parseDocumentOrFragment(input, parser, isFragment);
        LinkedList<Node> commentList = DOMUtilInternal.getChildNodeListMatching(doc, rule = new NodeConstraints(){

            @Override
            public boolean match(Node node, Object context) {
                return node.getNodeType() == 8;
            }
        }, true, null);
        if (commentList != null) {
            for (Node comment : commentList) {
                comment.getParentNode().removeChild(comment);
            }
        }
        return doc;
    }
}

